/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.protocol.jaxws.stack.jrf;

import HTTPClient.Cookie;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.MTOMFeature;
import oracle.stellent.ridc.IdcContext;
import oracle.stellent.ridc.RIDCCookie;
import oracle.stellent.ridc.model.DataFactory;
import oracle.stellent.ridc.protocol.ProtocolException;
import oracle.stellent.ridc.protocol.ServiceRequest;
import oracle.stellent.ridc.protocol.jaxws.JaxWSClient;
import oracle.stellent.ridc.protocol.jaxws.JaxWSClientConfig;
import oracle.stellent.ridc.protocol.jaxws.JaxWSClientConnection;
import oracle.stellent.ridc.protocol.jaxws.JaxWSProtocol;
import oracle.stellent.ridc.protocol.jaxws.obj.IdcWebRequest;
import oracle.stellent.ridc.protocol.jaxws.stack.jrf.JaxWSbkServiceStack;
import oracle.webservices.ClientFactory;
import oracle.webservices.ImplType;
import oracle.webservices.WsMetaFactory;
import weblogic.wsee.jws.jaxws.owsm.SecurityPolicyFeature;

public class JaxWSjrfServiceStack
extends JaxWSbkServiceStack {
    public JaxWSjrfServiceStack(ServiceRequest<JaxWSClientConnection> serviceRequest, DataFactory dataFactory, JaxWSClientConfig config, JaxWSProtocol protocol) throws ProtocolException {
        super(serviceRequest, dataFactory, config, protocol);
    }

    @Override
    public void getCookiesFromUserContext(IdcContext userContext, Map<String, Object> requestContext) throws ProtocolException {
        HashMap<Cookie, Cookie> cookies = new HashMap<Cookie, Cookie>();
        for (Map.Entry<String, RIDCCookie> entry : userContext.getCookies().entrySet()) {
            RIDCCookie idcCookie = entry.getValue();
            Cookie cookie = new Cookie(idcCookie.getName(), idcCookie.getValue(), idcCookie.getDomain(), idcCookie.getPath(), null, idcCookie.isSecure());
            cookies.put(cookie, cookie);
        }
        requestContext.put("oracle.webservices.cookieMap", cookies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IdcWebRequest getRequestPort() throws ProtocolException {
        IdcWebRequest requestPort;
        try {
            JaxWSClient client = (JaxWSClient)this.getProtocol().getClient();
            Map<String, Service> servicesMap = client.getServicesMap();
            JaxWSClientConfig config = this.getClientConfig();
            String url = config.getRequestServiceWSDLUrl();
            Service service = servicesMap.get(url);
            if (service == null) {
                String syncObject;
                String string = syncObject = (this.getClass().getName() + "#getRequestPort#" + url).intern();
                synchronized (string) {
                    service = servicesMap.get(url);
                    if (service == null) {
                        WsMetaFactory jrfWsMetaFactory = WsMetaFactory.newInstance((ImplType)ImplType.JRF);
                        ClientFactory jrfClientFactory = jrfWsMetaFactory.createClientFactory();
                        QName requestServiceQName = new QName(config.getRequestNamespaceUri(), config.getRequestServiceName());
                        service = jrfClientFactory.create(new URL(url), requestServiceQName);
                        servicesMap.put(url, service);
                    }
                }
            }
            QName requestPortQName = new QName(config.getRequestNamespaceUri(), config.getRequestServicePort());
            SecurityPolicyFeature noAuthSecurityFeature = new SecurityPolicyFeature("oracle/no_authentication_client_policy");
            SecurityPolicyFeature noMessageProtectionSecurityFeature = new SecurityPolicyFeature("oracle/no_messageprotection_client_policy");
            MTOMFeature mtomFeature = new MTOMFeature();
            requestPort = (IdcWebRequest)service.getPort(requestPortQName, IdcWebRequest.class, new WebServiceFeature[]{mtomFeature, noAuthSecurityFeature, noMessageProtectionSecurityFeature});
            Map requestContext = ((BindingProvider)requestPort).getRequestContext();
            requestContext.put("oracle.webservices.soap.streamingIncoming", "true");
            requestContext.put("oracle.webservices.soap.streamingOutgoing", "true");
            requestContext.put("oracle.webservices.soap.streamInputDefault", "true");
            requestContext.put("oracle.webservices.soap.memoryThreshold", "1000000");
            requestContext.put("oracle.webservices.soap.keepXop", "true");
            requestContext.put("oracle.webservices.httpConnTimeout", new Integer(this.getClientConfig().getSocketTimeout()));
            String idcService = this.getServiceRequest().getService();
            int readTimeoutMultiplier = idcService != null && (idcService.startsWith("CHECKIN_") || idcService.equals("GET_SEARCH_RESULTS")) ? 4 : 2;
            requestContext.put("oracle.webservices.httpReadTimeout", new Integer(readTimeoutMultiplier * this.getClientConfig().getSocketTimeout()));
        }
        catch (Exception e) {
            throw new ProtocolException(e);
        }
        return requestPort;
    }

    @Override
    public String getLoginStackNameForLog() {
        return JaxWSClientConfig.JAXWSSTACK.jrf.toString();
    }

    @Override
    public String getRequestStackNameForLog() {
        return JaxWSClientConfig.JAXWSSTACK.jrf.toString();
    }
}

