/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.protocol.jaxws.stack.wls;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.MTOMFeature;
import oracle.stellent.ridc.IdcContext;
import oracle.stellent.ridc.RIDCCookie;
import oracle.stellent.ridc.common.util.StringTools;
import oracle.stellent.ridc.model.DataFactory;
import oracle.stellent.ridc.protocol.ProtocolException;
import oracle.stellent.ridc.protocol.ServiceRequest;
import oracle.stellent.ridc.protocol.jaxws.JaxWSClient;
import oracle.stellent.ridc.protocol.jaxws.JaxWSClientConfig;
import oracle.stellent.ridc.protocol.jaxws.JaxWSClientConnection;
import oracle.stellent.ridc.protocol.jaxws.JaxWSProtocol;
import oracle.stellent.ridc.protocol.jaxws.obj.IdcWebLogin;
import oracle.stellent.ridc.protocol.jaxws.obj.IdcWebLoginService;
import oracle.stellent.ridc.protocol.jaxws.obj.IdcWebRequest;
import oracle.stellent.ridc.protocol.jaxws.obj.IdcWebRequestService;
import oracle.stellent.ridc.protocol.jaxws.stack.JaxWSServiceStack;
import weblogic.wsee.jws.jaxws.owsm.SecurityPolicyFeature;

public class JaxWSwlsServiceStack
extends JaxWSServiceStack {
    public JaxWSwlsServiceStack(ServiceRequest<JaxWSClientConnection> serviceRequest, DataFactory dataFactory, JaxWSClientConfig config, JaxWSProtocol protocol) throws ProtocolException {
        super(serviceRequest, dataFactory, config, protocol);
    }

    @Override
    public boolean saveCookiesToUserContext(IdcWebLogin loginPort) {
        Map responseContext = ((BindingProvider)loginPort).getResponseContext();
        Map httpResponseHeaders = (Map)responseContext.get("javax.xml.ws.http.response.headers");
        Collection cookies = (Collection)httpResponseHeaders.get("Set-cookie");
        if (cookies == null || cookies.isEmpty()) {
            this.logCookieWarning();
            return false;
        }
        HashMap<String, RIDCCookie> cookiesMap = new HashMap<String, RIDCCookie>();
        for (String cookieString : cookies) {
            RIDCCookie cookie = new RIDCCookie(cookieString);
            cookiesMap.put(cookie.getName(), cookie);
        }
        this.getServiceRequest().getUserContext().setCookies(cookiesMap);
        if (null == this.getServiceRequest().getUserContext().getCookie(this.getServiceRequest().getUserContext().getSessionCookie())) {
            this.logCookieWarning();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IdcWebLogin getLoginPort() throws ProtocolException {
        IdcWebLogin loginPort;
        try {
            JaxWSClient client = (JaxWSClient)this.getProtocol().getClient();
            Map<String, Service> servicesMap = client.getServicesMap();
            JaxWSClientConfig config = this.getClientConfig();
            String url = config.getLoginServiceWSDLUrl();
            Service service = servicesMap.get(url);
            if (service == null) {
                String syncObject;
                String string = syncObject = (this.getClass().getName() + "#getLoginPort#" + url).intern();
                synchronized (string) {
                    service = servicesMap.get(url);
                    if (service == null) {
                        QName loginServiceQName = new QName(config.getLoginNamespaceUri(), config.getLoginServiceName());
                        service = new IdcWebLoginService(new URL(url), loginServiceQName);
                        servicesMap.put(url, service);
                    }
                }
            }
            QName loginPortQName = new QName(config.getLoginNamespaceUri(), config.getLoginServicePort());
            SecurityPolicyFeature securityFeature = null;
            if (!StringTools.isEmpty(config.getClientSecurityPolicy())) {
                securityFeature = new SecurityPolicyFeature(config.getClientSecurityPolicy());
            }
            loginPort = ((IdcWebLoginService)service).getIdcWebLoginPort(loginPortQName, new WebServiceFeature[]{securityFeature});
        }
        catch (Exception e) {
            throw new ProtocolException(e);
        }
        return loginPort;
    }

    @Override
    public void getCookiesFromUserContext(IdcContext userContext, Map<String, Object> requestContext) throws ProtocolException {
        HashMap httpHeaders = new HashMap();
        ArrayList<String> cookieCollection = new ArrayList<String>();
        for (Map.Entry<String, RIDCCookie> entry : userContext.getCookies().entrySet()) {
            RIDCCookie idcCookie = entry.getValue();
            String cookieString = idcCookie.toString();
            cookieCollection.add(cookieString);
        }
        if (!cookieCollection.isEmpty()) {
            httpHeaders.put("cookie", cookieCollection);
        }
        requestContext.put("javax.xml.ws.http.request.headers", httpHeaders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IdcWebRequest getRequestPort() throws ProtocolException {
        IdcWebRequest requestPort;
        try {
            JaxWSClient client = (JaxWSClient)this.getProtocol().getClient();
            Map<String, Service> servicesMap = client.getServicesMap();
            JaxWSClientConfig config = this.getClientConfig();
            String url = config.getRequestServiceWSDLUrl();
            Service service = servicesMap.get(url);
            if (service == null) {
                String syncObject;
                String string = syncObject = (this.getClass().getName() + "#getRequestPort#" + url).intern();
                synchronized (string) {
                    service = servicesMap.get(url);
                    if (service == null) {
                        QName requestServiceQName = new QName(config.getRequestNamespaceUri(), config.getRequestServiceName());
                        service = new IdcWebRequestService(new URL(url), requestServiceQName);
                        servicesMap.put(url, service);
                    }
                }
            }
            QName requestPortQName = new QName(config.getRequestNamespaceUri(), config.getRequestServicePort());
            MTOMFeature mtomFeature = new MTOMFeature();
            requestPort = ((IdcWebRequestService)service).getIdcWebRequestPort(requestPortQName, new WebServiceFeature[]{mtomFeature});
        }
        catch (Exception e) {
            throw new ProtocolException(e);
        }
        return requestPort;
    }

    @Override
    public String getLoginStackNameForLog() {
        return JaxWSClientConfig.JAXWSSTACK.wls.toString();
    }

    @Override
    public String getRequestStackNameForLog() {
        return JaxWSClientConfig.JAXWSSTACK.wls.toString();
    }
}

