/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucm.client;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.ProxySelector;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oracle.stellent.ridc.IdcClient;
import oracle.stellent.ridc.IdcClientConfig;
import oracle.stellent.ridc.IdcClientException;
import oracle.stellent.ridc.IdcClientManager;
import oracle.stellent.ridc.IdcContext;
import oracle.stellent.ridc.RIDCCookie;
import oracle.stellent.ridc.common.http.utils.RIDCHttpConstants;
import oracle.stellent.ridc.common.log.LogFactory;
import oracle.stellent.ridc.common.log.simple.SimpleLogProvider;
import oracle.stellent.ridc.model.DataBinder;
import oracle.stellent.ridc.protocol.ServiceResponse;
import oracle.stellent.ridc.protocol.http.IdcHttpClientConfig;
import oracle.stellent.ridc.protocol.http.IdcHttpProtocol;
import oracle.stellent.ridc.protocol.intradoc.IntradocClientConfig;
import oracle.stellent.ridc.protocol.jaxws.JaxWSClientConfig;
import oracle.ucm.client.auth.AuthProxyClient;
import oracle.ucm.client.auth.URLConnectionFactory;
import oracle.ucm.client.auth.URLConnectionProxySelector;
import oracle.ucm.client.i18n.ClientMessages;
import oracle.ucm.client.utils.ClientUtils;
import oracle.ucm.client.utils.LogUtils;
import oracle.ucm.client.utils.ProgramOptionsProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTool {
    private ProgramOptionsProcessor m_op = null;
    private LogUtils m_logger;
    private boolean m_isSilent;
    private boolean m_isQuiet;
    private boolean m_isVerbose;
    private IdcClient m_idcClient;
    private IdcContext m_idcContext;
    protected Map<String, RIDCCookie> m_cookieMap;
    private boolean m_performLogout = true;
    private static final String HEADER_OPTION = "Tool.Header";
    private static final String HEADER2_OPTION = "Tool.Header2";
    private static final String COPYRIGHT_OPTION = "Tool.Copyright";
    private static final String ALLOW_RESTRICTIONS_OVERWRITES_OPTION = "Tool.AllowOverwrites";
    private static final Method s_RidcLogoutMethod;
    private boolean m_appendLog = false;

    public boolean setup(String[] args) throws IdcClientException {
        IdcClientConfig config;
        String url;
        String simpleRidcLogging;
        String usageRequest;
        boolean terminateEarly = false;
        ProgramOptionsProcessor op = new ProgramOptionsProcessor();
        String resource = this.getToolRestrictionsOptionsResource();
        try {
            op.load(resource, false);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        boolean allowRestrictionsOverwrite = ClientUtils.getTrimmedStringBooleanValue(op.get(ALLOW_RESTRICTIONS_OVERWRITES_OPTION));
        if (!allowRestrictionsOverwrite) {
            Set<String> restrictedOptions = op.getKeys();
            op.setRestrictedOptions(restrictedOptions);
        }
        ProgramOptionsProcessor temp = new ProgramOptionsProcessor(args);
        String defaultOptionsResourceOverride = ClientUtils.getStringIfPostTrimNonEmpty(temp.get("properties", "props", "options"));
        String defaultOptionsPropertiesFileOverride = ClientUtils.getStringIfPostTrimNonEmpty(temp.get("propertiesFile"));
        if (defaultOptionsResourceOverride != null) {
            op.load(defaultOptionsResourceOverride, true);
        } else if (defaultOptionsPropertiesFileOverride != null) {
            op.load(new File(defaultOptionsPropertiesFileOverride), true);
        } else {
            try {
                op.load(this.getToolDefaultOptionsResource(), true);
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        op.load(args, true);
        this.setOptionsProcessor(op);
        this.setLogger(new LogUtils());
        String versionCheck = op.get("version", "v");
        if (ClientUtils.getBooleanValue(versionCheck, false, true)) {
            this.log(this.getToolClassAndRevision());
            terminateEarly = true;
            return terminateEarly;
        }
        PrintWriter pw = null;
        String logFileName = ClientUtils.getStringIfPostTrimNonEmpty(op.get("LOG_FILE_NAME", "logFileName", "logFile"));
        if (logFileName != null) {
            File logFile = ClientUtils.getWriteableFile(logFileName);
            this.m_appendLog = ClientUtils.getTrimmedStringBooleanValue(op.get("LOG_FILE_APPEND"));
            try {
                pw = new PrintWriter((Writer)new FileWriter(logFile, this.m_appendLog), true);
            }
            catch (IOException e) {
                throw new IllegalStateException(ClientMessages.ucmclient_log_file_write_error(logFileName).toExceptionString(), e);
            }
        }
        if (pw != null) {
            this.setLogger(new LogUtils(pw));
            if (this.m_appendLog) {
                this.log();
            }
        }
        String silentValue = op.get("silent");
        this.setSilent(ClientUtils.getBooleanValue(silentValue, false, true));
        String quietValue = op.get("quiet", "silent");
        this.setQuiet(!this.isSilent() && ClientUtils.getBooleanValue(quietValue, false, true));
        if (!this.isSilent() && !this.isQuiet()) {
            String copyright;
            String header = ClientUtils.getStringIfPostTrimNonEmpty(op.get(HEADER_OPTION));
            this.log(header != null ? header : this.getToolHeader());
            String header2 = ClientUtils.getStringIfPostTrimNonEmpty(op.get(HEADER2_OPTION));
            if (header2 != null) {
                this.log(header2);
            }
            if ((copyright = ClientUtils.getStringIfPostTrimNonEmpty(op.get(COPYRIGHT_OPTION))) != null) {
                this.log(copyright);
            }
        }
        if (ClientUtils.getBooleanValue(usageRequest = op.get("usage", "help", "h", "?"), false, true)) {
            this.log();
            this.log(this.getUsage());
            this.log();
            terminateEarly = true;
            return terminateEarly;
        }
        String connectionHelpRequest = op.get("connectionhelp", "urlhelp");
        if (ClientUtils.getBooleanValue(connectionHelpRequest, false, true)) {
            this.log();
            this.log(this.getConnectionUsage());
            this.log();
            terminateEarly = true;
            return terminateEarly;
        }
        String verboseValue = op.get("verbose", "debug");
        this.setVerbose(!this.isSilent() && !this.isQuiet() && ClientUtils.getBooleanValue(verboseValue, false, true));
        op.setSystemProperties();
        if (this.isVerbose()) {
            String httpnph;
            this.log(this.getToolClassAndRevision());
            String osn = System.getProperty("os.name");
            String osa = System.getProperty("os.arch");
            String osv = System.getProperty("os.version");
            this.log();
            this.log("OS: " + osn + " / " + osa + " / " + osv);
            String jven = System.getProperty("java.vendor");
            String jver = System.getProperty("java.version");
            String jrv = System.getProperty("java.runtime.version");
            this.log("Java: " + jven + " / " + jver + " / " + jrv);
            String jvmn = System.getProperty("java.vm.name");
            String jvmven = System.getProperty("java.vm.vendor");
            String jvmver = System.getProperty("java.vm.version");
            this.log("JVM: " + jvmn + " / " + jvmven + " / " + jvmver);
            String httph = System.getProperty("http.proxyHost");
            String httpp = System.getProperty("http.proxyPort");
            if (httph != null) {
                this.log("HTTP Proxy System Properties: " + httph + " / " + httpp);
            }
            String httpsh = System.getProperty("https.proxyHost");
            String httpsp = System.getProperty("https.proxyPort");
            if (httpsh != null) {
                this.log("HTTPS Proxy System Properties: " + httpsh + " / " + httpsp);
            }
            if ((httpnph = System.getProperty("http.nonProxyHosts")) != null) {
                this.log("HTTP Proxy Non-Proxy-Hosts System Properties: " + httpnph);
            }
        }
        if (this.isVerbose()) {
            this.log();
            this.log(ClientMessages.ucmclient_program_options_supplied().toString());
            for (String option : op.toString().split("[\\r\\n]+")) {
                this.log(option);
            }
            this.log();
        }
        if (ClientUtils.getBooleanValue(simpleRidcLogging = op.get("RIDCLogging", "simpleRIDCLogging"), false, true)) {
            LogFactory.setLogProvider(new SimpleLogProvider());
        }
        if ((url = op.get("url", "connectionURL")) == null) {
            throw new IllegalStateException(ClientMessages.ucmclient_required_option_error("url").toExceptionString());
        }
        if (!ClientUtils.nonEmptyPostTrim(url)) {
            throw new IllegalStateException(ClientMessages.ucmclient_invalid_option_value_error("url", url).toExceptionString());
        }
        boolean autocorrectUrl = ClientUtils.getBooleanValue(op.get("autocorrectURL"), true, true);
        if (autocorrectUrl) {
            if (url.endsWith("/cs")) {
                url = url + "/idcplg";
            } else if (url.endsWith("/cs/")) {
                url = url + "idcplg";
            } else if (url.endsWith("/_dav")) {
                url = url + "/cs/idcplg";
            } else if (url.endsWith("/_dav/")) {
                url = url + "cs/idcplg";
            }
        }
        String cookies = null;
        String authProxy = op.get("authProxy");
        if (ClientUtils.nonEmptyPostTrim(authProxy)) {
            boolean authProxySSLEnabled = ClientUtils.getBooleanValue(op.get("authProxySSL", "authProxySSLEnabled"), false, true);
            String authProxySSLTrustStore = ClientUtils.getStringIfPostTrimNonEmpty(op.get("authProxySSLTrustStore"));
            String authProxySSLTrustStorePassword = ClientUtils.getStringIfPostTrimNonEmpty(op.get("authProxySSLTrustStorePassword"));
            boolean authProxySSLClientAuth = ClientUtils.getBooleanValue(op.get("authProxySSLClientAuth", "authProxySSLClientAuthEnabled"), false, true);
            String authProxySSLKeyStore = ClientUtils.getStringIfPostTrimNonEmpty(op.get("authProxySSLKeyStore"));
            String authProxySSLKeyStorePassword = ClientUtils.getStringIfPostTrimNonEmpty(op.get("authProxySSLKeyStorePassword"));
            String authProxySSLKeyStoreClientKeyAlias = ClientUtils.getStringIfPostTrimNonEmpty(op.get("authProxySSLKeyStoreClientKeyAlias"));
            String authProxySSLKeyStoreClientKeyPassword = ClientUtils.getStringIfPostTrimNonEmpty(op.get("authProxySSLKeyStoreClientKeyPassword"));
            cookies = new AuthProxyClient(this.isVerbose() ? this.getLogger() : null).getCookies(url, authProxy, authProxySSLEnabled, authProxySSLTrustStore, authProxySSLTrustStorePassword, authProxySSLClientAuth, authProxySSLKeyStore, authProxySSLKeyStorePassword, authProxySSLKeyStoreClientKeyAlias, authProxySSLKeyStoreClientKeyPassword);
        }
        if (ClientUtils.nonEmptyPostTrim(cookies)) {
            URL u = null;
            try {
                u = new URL(url);
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException(e);
            }
            HashMap<String, RIDCCookie> cookieMap = new HashMap<String, RIDCCookie>();
            for (String cookie : cookies.split(";")) {
                int equalsIndex = cookie.indexOf(61);
                if (equalsIndex < 1 || equalsIndex + 1 >= cookie.length()) continue;
                String cookieName = cookie.substring(0, equalsIndex).trim();
                String cookieValue = cookie.substring(equalsIndex + 1).trim();
                if (!ClientUtils.nonEmptyPostTrim(cookieName) || !ClientUtils.nonEmptyPostTrim(cookieValue)) continue;
                RIDCCookie ridcCookie = new RIDCCookie(u.getHost(), cookieName, cookieValue, u.getPath(), -1, false);
                cookieMap.put(cookieName, ridcCookie);
            }
            if (cookieMap != null && cookieMap.size() > 0) {
                this.m_cookieMap = cookieMap;
            }
        }
        this.setPerformLogout(ClientUtils.getBooleanValue(op.get("performLogout"), this.m_cookieMap == null, true));
        String username = op.get("username", "user");
        if (username == null && this.m_cookieMap == null) {
            throw new IllegalStateException(ClientMessages.ucmclient_required_option_error("username").toExceptionString());
        }
        if (!ClientUtils.nonEmptyPostTrim(username) && this.m_cookieMap == null) {
            throw new IllegalStateException(ClientMessages.ucmclient_invalid_option_value_error("username", username).toExceptionString());
        }
        String password = op.get("password");
        String passwordFile = op.get("passwordFile");
        String socketTimeout = op.get("timeout", "socketTimeout");
        int timeout = ClientUtils.getIntValue(socketTimeout, 300);
        IdcClientManager manager = new IdcClientManager();
        IdcClient idcClient = manager.createClient(url);
        this.setIdcClient(idcClient);
        Object idcConfig = idcClient.getConfig();
        ((IdcClientConfig)idcConfig).setSocketTimeout(timeout <= 0 ? timeout : timeout * 1000);
        IdcContext idcContext = null;
        if (idcConfig instanceof IntradocClientConfig) {
            idcContext = new IdcContext(username);
        } else if (idcConfig instanceof IdcHttpClientConfig) {
            String httpLibrary;
            config = (IdcHttpClientConfig)idcConfig;
            if (((password = this.getPassword(password, passwordFile)) == null || password.length() == 0) && this.m_cookieMap == null) {
                throw new IllegalStateException(ClientMessages.ucmclient_required_option_error("password").toExceptionString());
            }
            idcContext = new IdcContext(username, password);
            if (this.m_cookieMap != null) {
                idcContext.setCookies(this.m_cookieMap);
            }
            ((IdcHttpClientConfig)config).setHttpLibrary(RIDCHttpConstants.HttpLibrary.valueOf((httpLibrary = ClientUtils.getStringIfPostTrimNonEmpty(op.get("httpLib", "httpLibrary"))) != null ? httpLibrary : "httpurlconnection"));
            String authHandler = ClientUtils.getStringIfPostTrimNonEmpty(op.get("authHandler"));
            if (authHandler != null) {
                try {
                    Class<?> handler = Class.forName(authHandler);
                    IdcHttpProtocol.addHandlerFirst(IdcContext.HttpAuthScheme.CUSTOM, handler);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException(e.getMessage(), e);
                }
            }
            String proxyHost = op.get("proxyHost", "http.proxyHost");
            String proxyPort = op.get("proxyPort", "http.proxyPort");
            final int port = ClientUtils.getPositiveIntValue(proxyPort, 80);
            String nonProxyHosts = op.get("nonProxyHosts", "http.nonProxyHosts");
            if (ClientUtils.nonEmptyPostTrim(proxyHost)) {
                ((IdcHttpClientConfig)config).setUseSystemProxy(false);
                if (((IdcHttpClientConfig)config).getHttpLibrary().equals((Object)RIDCHttpConstants.HttpLibrary.httpurlconnection)) {
                    config.setProperty("httpurlconnection.httpURLConnectionFactory", URLConnectionFactory.class.getName());
                    URLConnectionProxySelector proxySelector = new URLConnectionProxySelector(ProxySelector.getDefault(), proxyHost, port, nonProxyHosts, this.isVerbose() ? this.getLogger() : null);
                    ProxySelector.setDefault(proxySelector);
                } else {
                    ((IdcHttpClientConfig)config).setProxyHost(proxyHost);
                    ((IdcHttpClientConfig)config).setProxyPort(port);
                    if (ClientUtils.nonEmptyPostTrim(nonProxyHosts)) {
                        ((IdcHttpClientConfig)config).setNonProxyHosts(nonProxyHosts);
                    }
                }
            }
            final String proxyUsername = op.get("proxyUsername", "http.proxyUsername");
            String proxyPassword = op.get("proxyPassword", "http.proxyPassword");
            String proxyPasswordFile = op.get("proxyPasswordFile");
            final String proxyPass = this.getPassword(proxyPassword, proxyPasswordFile);
            String proxyRealm = op.get("proxyRealm", "http.proxyRealm");
            if (ClientUtils.nonEmpty(proxyUsername) && ClientUtils.nonEmpty(proxyPass)) {
                if (((IdcHttpClientConfig)config).getHttpLibrary().equals((Object)RIDCHttpConstants.HttpLibrary.httpurlconnection)) {
                    Authenticator.setDefault(new Authenticator(){

                        public PasswordAuthentication getPasswordAuthentication() {
                            if (this.getRequestorType() == Authenticator.RequestorType.PROXY && this.getRequestingPort() == port) {
                                return new PasswordAuthentication(proxyUsername, proxyPass.toCharArray());
                            }
                            return super.getPasswordAuthentication();
                        }
                    });
                } else {
                    ((IdcHttpClientConfig)config).setProxyUsername(proxyUsername);
                    ((IdcHttpClientConfig)config).setProxyPassword(proxyPass);
                    if (proxyRealm != null) {
                        ((IdcHttpClientConfig)config).setProxyRealm(proxyRealm);
                    }
                }
            }
        } else if (idcConfig instanceof JaxWSClientConfig) {
            String jpsconfigFile;
            String policy;
            config = (JaxWSClientConfig)idcConfig;
            idcContext = (password = this.getPassword(password, passwordFile)) == null ? new IdcContext(username) : new IdcContext(username, password);
            String stack = ClientUtils.getStringIfPostTrimNonEmpty(op.get("stack", "jaxwsStack"));
            if (stack != null) {
                ((JaxWSClientConfig)config).setJaxWSStack(JaxWSClientConfig.JAXWSSTACK.valueOf(stack));
            }
            if ((policy = ClientUtils.getStringIfPostTrimNonEmpty(op.get("policy", "jaxwsPolicy", "wsPolicy"))) != null) {
                ((JaxWSClientConfig)config).setClientSecurityPolicy(policy);
            }
            if ((jpsconfigFile = ClientUtils.getStringIfPostTrimNonEmpty(op.get("jpsConfig", "jpsConfigFile"))) != null) {
                ((JaxWSClientConfig)config).setJpsConfigFile(jpsconfigFile);
            }
        }
        this.setIdcContext(idcContext);
        return terminateEarly;
    }

    public void logout() {
        if (this.getPerformLogout()) {
            IdcContext userContext = this.getIdcContext();
            this.logout(userContext);
            userContext = null;
            this.setIdcContext(userContext);
        }
    }

    public void logout(IdcContext userContext) {
        IdcClient client = this.getIdcClient();
        if (client != null && userContext != null && s_RidcLogoutMethod != null) {
            try {
                s_RidcLogoutMethod.invoke((Object)client, userContext);
            }
            catch (IllegalAccessException e) {
                this.log(e);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
            }
        }
    }

    public void ping() throws Exception {
        if (!this.isSilent() && !this.isQuiet()) {
            this.log(ClientMessages.ucmclient_performing_connection_test().toString());
        }
        Object idcConfig = this.getIdcClient().getConfig();
        int existingTimeout = ((IdcClientConfig)idcConfig).getSocketTimeout();
        ((IdcClientConfig)idcConfig).setSocketTimeout(35000);
        DataBinder binder = this.createServiceRequest("PING_SERVER");
        ServiceResponse response = this.sendRequest(binder);
        DataBinder responseBinder = response.getResponseAsBinder();
        if (responseBinder == null || !"PING_SERVER".equals(responseBinder.getLocal("IdcService"))) {
            throw new IllegalStateException(ClientMessages.ucmclient_content_server_unavailable_error().toExceptionString());
        }
        String dUser = responseBinder.getLocal("dUser");
        if (!this.getIdcContext().getUser().equalsIgnoreCase(dUser) && this.m_cookieMap == null) {
            throw new IllegalStateException(ClientMessages.ucmclient_unexpected_user_error(dUser).toExceptionString());
        }
        if (this.isVerbose()) {
            this.log();
            this.log(ClientMessages.ucmclient_connection_test_response().toString());
            this.log(responseBinder);
        }
        if (!this.isSilent()) {
            this.log(ClientMessages.ucmclient_connection_test_successful().toString());
        }
        ((IdcClientConfig)idcConfig).setSocketTimeout(existingTimeout);
    }

    private String getPassword(String password, String passwordFile) {
        if (ClientUtils.nonEmptyPostTrim(passwordFile)) {
            return ClientUtils.readPasswordFromFile(passwordFile);
        }
        return password;
    }

    public void setOptionsProcessor(ProgramOptionsProcessor processor) {
        this.m_op = processor;
    }

    public ProgramOptionsProcessor getOptionsProcessor() {
        return this.m_op;
    }

    public void setLogger(LogUtils logger) {
        this.m_logger = logger;
    }

    public LogUtils getLogger() {
        return this.m_logger;
    }

    protected void log() {
        this.getLogger().log();
    }

    protected void log(String message) {
        this.getLogger().log(message);
    }

    protected void print(String message) {
        this.getLogger().print(message);
    }

    protected void log(Exception e) {
        this.getLogger().logException(e);
    }

    protected void log(DataBinder db) {
        String indent = this.getLogger().getDefaultIndent();
        this.getLogger().logDataBinder(db, indent);
    }

    public void setPerformLogout(boolean performLogout) {
        this.m_performLogout = performLogout;
    }

    public boolean getPerformLogout() {
        return this.m_performLogout;
    }

    public void setSilent(boolean isSilent) {
        this.m_isSilent = isSilent;
    }

    public boolean isSilent() {
        return this.m_isSilent;
    }

    public void setQuiet(boolean isQuiet) {
        this.m_isQuiet = isQuiet;
    }

    public boolean isQuiet() {
        return this.m_isQuiet;
    }

    public void setVerbose(boolean isVerbose) {
        this.m_isVerbose = isVerbose;
    }

    public boolean isVerbose() {
        return this.m_isVerbose;
    }

    public void setIdcClient(IdcClient idcClient) {
        this.m_idcClient = idcClient;
    }

    public IdcClient getIdcClient() {
        return this.m_idcClient;
    }

    public void setIdcContext(IdcContext idcContext) {
        this.m_idcContext = idcContext;
    }

    public IdcContext getIdcContext() {
        return this.m_idcContext;
    }

    public DataBinder createServiceRequest(String service) {
        IdcClient idcClient = this.getIdcClient();
        DataBinder binder = idcClient.createBinder();
        binder.putLocal("IdcService", service);
        return binder;
    }

    public void addRequestProperty(DataBinder requestBinder, String name, String value) {
        requestBinder.putLocal(name, value);
    }

    public ServiceResponse sendRequest(DataBinder binder) throws IdcClientException {
        IdcClient idcClient = this.getIdcClient();
        IdcContext idcContext = this.getIdcContext();
        return idcClient.sendRequest(idcContext, binder);
    }

    protected Map<String, String> getCustomMetadataIfPresent(ProgramOptionsProcessor op) {
        HashMap<String, String> metadata = new HashMap<String, String>(2);
        for (int i = 0; i < 10; ++i) {
            String key;
            String argkey = "k" + i;
            String argval = "v" + i;
            if (!op.containsKey(argkey) || !op.containsKey(argval) || (key = ClientUtils.getStringIfPostTrimNonEmpty(op.get(argkey))) == null) continue;
            String value = ClientUtils.getStringIfPostTrimNonEmpty(op.get(argval));
            String string = value = value == null ? "" : value;
            if (!this.isSilent() && !this.isQuiet()) {
                this.log(" * " + ClientMessages.ucmclient_custom_metadata_added_to_request_payload(key, value).toString());
            }
            metadata.put(key, value);
        }
        return metadata;
    }

    protected void closeLog() {
        if (this.m_appendLog) {
            this.log();
            this.log("##################################################");
        }
        this.getLogger().close();
    }

    protected String getConnectionUsage() {
        return ClientMessages.ucmclient_connection_usage().toString();
    }

    protected abstract String getToolClassAndRevision();

    protected abstract String getToolHeader();

    protected abstract String getToolRestrictionsOptionsResource();

    protected abstract String getToolDefaultOptionsResource();

    protected abstract String getUsage();

    public static Object idcVersionInfo(Object arg) {
        return "releaseInfo=dev,releaseRevision=$Rev: 128389 $";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Method logoutMethod = null;
        try {
            logoutMethod = IdcClient.class.getMethod("logout", IdcContext.class);
        }
        catch (NoSuchMethodException e) {
            logoutMethod = null;
        }
        finally {
            s_RidcLogoutMethod = logoutMethod;
        }
    }
}

