/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucm.client;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.Map;
import oracle.stellent.ridc.IdcClientException;
import oracle.stellent.ridc.model.DataBinder;
import oracle.stellent.ridc.model.DataObject;
import oracle.stellent.ridc.model.DataResultSet;
import oracle.stellent.ridc.protocol.ServiceResponse;
import oracle.ucm.client.AbstractTool;
import oracle.ucm.client.i18n.ClientMessages;
import oracle.ucm.client.utils.ClientUtils;
import oracle.ucm.client.utils.ProgramOptionsProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadTool
extends AbstractTool {
    private static final String TOOL = "Oracle WebCenter Content Document Transfer Utility";
    private static final String TOOL_RESTRICTIONS_OPTIONS_RESOURCE = "oracle/ucm/client/DownloadTool.properties";
    private static final String TOOL_DEFAULT_OPTIONS_RESOURCE = "DownloadTool.properties";

    public static void main(String[] args) {
        try {
            DownloadTool tool = new DownloadTool();
            try {
                boolean terminateEarly = tool.setup(args);
                if (terminateEarly) {
                    return;
                }
                DownloadResult downloadResult = tool.run();
            }
            catch (Exception e) {
                tool.log();
                tool.log("Error - " + e.getMessage());
                if (!tool.isSilent() && !tool.isQuiet()) {
                    tool.log(e);
                }
                throw e;
            }
            finally {
                tool.logout();
                tool.closeLog();
            }
            System.exit(0);
        }
        catch (Exception e) {
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadResult run() throws Exception {
        String filePath;
        ServiceResponse response;
        ProgramOptionsProcessor op = this.getOptionsProcessor();
        String dID = ClientUtils.getStringIfPostTrimNonEmpty(op.get("dID"));
        String dDocName = ClientUtils.getStringIfPostTrimNonEmpty(op.get("dDocName"));
        String revisionSelectionMethod = ClientUtils.getStringIfPostTrimNonEmpty(op.get("RevisionSelectionMethod"));
        String rendition = ClientUtils.getStringIfPostTrimNonEmpty(op.get("rendition"));
        boolean ping = ClientUtils.getBooleanValue(op.get("ping", "testConnection"), false, true);
        if (ping || dID == null && dDocName == null) {
            this.ping();
            return null;
        }
        Map<String, String> metadata = this.getCustomMetadataIfPresent(op);
        boolean performMD5 = ClientUtils.getBooleanValue(op.get("md5"), false, true) || ClientUtils.getBooleanValue(op.get("md5uppercase"), false, true) || ClientUtils.getBooleanValue(op.get("md5lowercase"), false, true);
        boolean md5Only = ClientUtils.getBooleanValue(op.get("md5Only"), false, true);
        if (md5Only) {
            performMD5 = true;
        }
        String outputFile = null;
        if (!md5Only && (outputFile = ClientUtils.getStringIfPostTrimNonEmpty(op.get("outputFile", "output", "destinationFile", "destination"))) == null) {
            String outputDir = ClientUtils.getStringIfPostTrimNonEmpty(op.get("directory", "outputDir", "outputDirectory", "destinationDir", "destinationDirectory", "localDir", "localDirectory"));
            if (outputDir == null) {
                outputDir = ClientUtils.getStringIfPostTrimNonEmpty(System.getProperty("user.dir"));
            }
            if (outputDir != null) {
                File localDirectory = ClientUtils.getReadableDirectory(outputDir);
                String originalName = this.getOriginalName(dID, dDocName, revisionSelectionMethod, rendition, metadata);
                outputFile = new File(localDirectory, originalName).getAbsolutePath();
            } else if (!performMD5) {
                throw new IllegalStateException(ClientMessages.ucmclient_required_option_error("outputFile").toExceptionString());
            }
        }
        File file = outputFile == null ? null : ClientUtils.getWriteableFile(outputFile);
        DataBinder request = this.createServiceRequest("GET_FILE");
        if (dID != null) {
            this.addRequestProperty(request, "dID", dID);
        } else {
            this.addRequestProperty(request, "dDocName", dDocName);
            this.addRequestProperty(request, "RevisionSelectionMethod", revisionSelectionMethod == null ? "Latest" : revisionSelectionMethod);
        }
        if (rendition != null) {
            this.addRequestProperty(request, "Rendition", rendition);
        }
        for (Map.Entry<String, String> entry : metadata.entrySet()) {
            this.addRequestProperty(request, entry.getKey(), entry.getValue());
        }
        if (this.isVerbose()) {
            this.log(ClientMessages.ucmclient_content_server_request_payload().toString());
            this.log(request);
        }
        long initial = System.currentTimeMillis();
        if (!this.isSilent() && !this.isQuiet()) {
            this.log(ClientMessages.ucmclient_performing_download().toString());
        }
        if ((response = this.sendRequest(request)) == null) {
            throw new IllegalStateException(ClientMessages.ucmclient_download_response_null_error().toExceptionString());
        }
        if (response.getResponseType().equals((Object)ServiceResponse.ResponseType.BINDER)) {
            DataBinder responseBinder = response.getResponseAsBinder(false);
            if (!this.isSilent() && !this.isQuiet()) {
                this.log();
                this.log(ClientMessages.ucmclient_download_response_not_a_stream_error().toString());
                this.log(responseBinder);
            }
            throw new IllegalStateException(ClientMessages.ucmclient_download_response_not_a_stream_error().toExceptionString());
        }
        long reportedSize = Long.parseLong(response.getHeader("Content-Length"));
        if (this.isVerbose()) {
            this.log(ClientMessages.ucmclient_download_reported_size(reportedSize).toString());
        }
        InputStream in = response.getResponseStream();
        BufferedOutputStream out = null;
        long bytesRead = 0L;
        String md5 = null;
        try {
            MessageDigest md = null;
            if (performMD5) {
                md = MessageDigest.getInstance("MD5");
                in = new DigestInputStream(in, md);
            }
            if (file != null) {
                out = new BufferedOutputStream(new FileOutputStream(file));
            }
            byte[] buffer = new byte[32768];
            int read = 0;
            while ((read = in.read(buffer, 0, buffer.length)) != -1) {
                bytesRead += (long)read;
                if (out == null) continue;
                ((OutputStream)out).write(buffer, 0, read);
            }
            if (performMD5) {
                md5 = ClientUtils.asHex(md.digest());
            }
        }
        catch (Throwable throwable) {
            ClientUtils.streamClose(out);
            ClientUtils.streamDrain(in);
            ClientUtils.streamClose(in);
            throw throwable;
        }
        ClientUtils.streamClose(out);
        ClientUtils.streamDrain(in);
        ClientUtils.streamClose(in);
        long duration = (System.currentTimeMillis() - initial) / 1000L;
        if (this.isVerbose()) {
            this.log(ClientMessages.ucmclient_download_stats(duration, bytesRead).toString());
        }
        if (!this.isSilent()) {
            this.log(ClientMessages.ucmclient_download_successful().toString());
        }
        String string = filePath = file == null ? null : file.getAbsolutePath();
        if (!this.isSilent() && !this.isQuiet() && filePath != null) {
            this.log(ClientMessages.ucmclient_download_output_file(filePath).toString());
        }
        if (performMD5) {
            String string2 = md5 = ClientUtils.getBooleanValue(op.get("md5lowercase"), false, true) ? md5.toLowerCase() : md5.toUpperCase();
            if (!this.isSilent()) {
                this.log("[MD5=" + md5 + "]");
            }
        }
        DownloadResult result = new DownloadResult();
        result.setFilePath(filePath);
        result.setMd5(md5);
        result.setBytesRead(bytesRead);
        result.setDuration(duration);
        result.setSourceDID(dID);
        result.setSourceDDocName(dDocName);
        return result;
    }

    protected String getOriginalName(String dID, String dDocName, String revisionSelectionMethod, String rendition, Map<String, String> metadata) throws IdcClientException {
        ServiceResponse response;
        String service = dID != null ? "DOC_INFO" : "DOC_INFO_BY_NAME";
        DataBinder request = this.createServiceRequest(service);
        if (dID != null) {
            this.addRequestProperty(request, "dID", dID);
        } else {
            this.addRequestProperty(request, "dDocName", dDocName);
            this.addRequestProperty(request, "RevisionSelectionMethod", revisionSelectionMethod == null ? "Latest" : revisionSelectionMethod);
        }
        for (Map.Entry<String, String> entry : metadata.entrySet()) {
            this.addRequestProperty(request, entry.getKey(), entry.getValue());
        }
        if (this.isVerbose()) {
            this.log(ClientMessages.ucmclient_content_server_request_payload().toString());
            this.log(request);
        }
        if ((response = this.sendRequest(request)) == null || !response.getResponseType().equals((Object)ServiceResponse.ResponseType.BINDER)) {
            throw new IllegalStateException(ClientMessages.ucmclient_invalid_response_error(service).toExceptionString());
        }
        DataBinder responseBinder = response.getResponseAsBinder();
        if (this.isVerbose()) {
            this.log();
            this.log(ClientMessages.ucmclient_content_server_response_payload().toString());
            this.log(responseBinder);
        }
        DataResultSet resultSet = responseBinder.getResultSet("DOC_INFO");
        DataObject dataObject = resultSet.getRows().get(0);
        String originalName = (String)dataObject.get("dOriginalName");
        return originalName;
    }

    @Override
    protected String getToolClassAndRevision() {
        String revision = ClientUtils.getRevision(DownloadTool.idcVersionInfo(null));
        String parentRevision = ClientUtils.getRevision(AbstractTool.idcVersionInfo(null));
        return "DownloadTool" + (revision != null && revision.length() > 0 ? " [r" + revision + "]/[p" + parentRevision + "]" : "");
    }

    @Override
    protected String getUsage() {
        return ClientMessages.ucmclient_download_usage().toString();
    }

    @Override
    protected String getToolHeader() {
        return TOOL;
    }

    @Override
    protected String getToolRestrictionsOptionsResource() {
        return TOOL_RESTRICTIONS_OPTIONS_RESOURCE;
    }

    @Override
    protected String getToolDefaultOptionsResource() {
        return TOOL_DEFAULT_OPTIONS_RESOURCE;
    }

    public static Object idcVersionInfo(Object arg) {
        return "releaseInfo=dev,releaseRevision=$Rev: 122355 $";
    }

    public static class DownloadResult {
        private String m_filePath;
        private String m_md5;
        private long m_bytesRead;
        private long m_duration;
        private String m_sourceDID;
        private String m_sourceDDocName;

        protected void setFilePath(String filePath) {
            this.m_filePath = filePath;
        }

        public String getFilePath() {
            return this.m_filePath;
        }

        protected void setMd5(String md5) {
            this.m_md5 = md5;
        }

        public String getMd5() {
            return this.m_md5;
        }

        protected void setBytesRead(long bytesRead) {
            this.m_bytesRead = bytesRead;
        }

        public long getBytesRead() {
            return this.m_bytesRead;
        }

        protected void setDuration(long duration) {
            this.m_duration = duration;
        }

        public long getDuration() {
            return this.m_duration;
        }

        protected void setSourceDID(String sourceDID) {
            this.m_sourceDID = sourceDID;
        }

        public String getSourceDID() {
            return this.m_sourceDID;
        }

        protected void setSourceDDocName(String sourceDDocName) {
            this.m_sourceDDocName = sourceDDocName;
        }

        public String getSourceDDocName() {
            return this.m_sourceDDocName;
        }
    }
}

