/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucm.client;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Locale;
import oracle.ucm.client.AbstractTool;
import oracle.ucm.client.DownloadTool;
import oracle.ucm.client.SearchTool;
import oracle.ucm.client.StorageTool;
import oracle.ucm.client.UploadTool;
import oracle.ucm.client.utils.ClientUtils;

public class JarEntryClass {
    public static void main(String[] args) {
        boolean debug = Boolean.parseBoolean(System.getProperty("debugtool", "false"));
        if (args != null && args.length >= 1) {
            if (ClassLoader.getSystemClassLoader() instanceof URLClassLoader) {
                URLClassLoader loader = (URLClassLoader)ClassLoader.getSystemClassLoader();
                String customClasspath = System.getenv("CUSTOM_CLASSPATH");
                if (customClasspath != null) {
                    String[] classTokens;
                    if (debug) {
                        System.out.println("CUSTOM_CLASSPATH environment variable detected");
                    }
                    boolean isWindows = System.getProperty("os.name") != null && System.getProperty("os.name").toLowerCase(Locale.US).startsWith("windows");
                    String separator = isWindows ? ";" : ":";
                    for (String token : classTokens = customClasspath.split(separator)) {
                        if (token == null || token.length() <= 0) continue;
                        File f = new File(token);
                        if (debug) {
                            System.out.println("Attempting to add " + f + " to system class loader ...");
                        }
                        JarEntryClass.addFileToUrlClassLoader(loader, f);
                    }
                }
            }
            String[] destArgs = new String[args.length - 1];
            System.arraycopy(args, 1, destArgs, 0, args.length - 1);
            if (args[0].matches("(?i:.*UPLOAD.*)")) {
                UploadTool.main(destArgs);
            } else if (args[0].matches("(?i:.*DOWNLOAD.*)")) {
                DownloadTool.main(destArgs);
            } else if (args[0].matches("(?i:.*SEARCH.*)")) {
                SearchTool.main(destArgs);
            } else if (args[0].matches("(?i:.*STORAGE.*)")) {
                StorageTool.main(destArgs);
            } else if (args[0].matches("(?i:^-version$)")) {
                JarEntryClass.version();
            } else {
                JarEntryClass.usage();
            }
        } else {
            JarEntryClass.usage();
        }
    }

    private static void addFileToUrlClassLoader(URLClassLoader loader, File file) {
        if (file != null) {
            if (!file.exists()) {
                return;
            }
            if (file.isDirectory() || file.isFile()) {
                // empty if block
            }
        }
        try {
            Method m = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            m.setAccessible(true);
            m.invoke((Object)loader, file.toURI().toURL());
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    private static void logLoader(URLClassLoader loader) {
        System.err.println("\nURLClassLoader entries:");
        for (URL u : loader.getURLs()) {
            System.err.println(u);
        }
    }

    public static Object idcVersionInfo(Object arg) {
        return "releaseInfo=dev,releaseRevision=$Rev: 123575 $";
    }

    private static void version() {
        String parentRevision = ClientUtils.getRevision(AbstractTool.idcVersionInfo(null));
        String uploadRevision = ClientUtils.getRevision(UploadTool.idcVersionInfo(null));
        String downloadRevision = ClientUtils.getRevision(DownloadTool.idcVersionInfo(null));
        String searchRevision = ClientUtils.getRevision(SearchTool.idcVersionInfo(null));
        String storageRevision = ClientUtils.getRevision(StorageTool.idcVersionInfo(null));
        System.out.println("AbstractTool [p" + parentRevision + "]");
        System.out.println("DownloadTool [r" + downloadRevision + "]");
        System.out.println("  UploadTool [r" + uploadRevision + "]");
        System.out.println("  SearchTool [r" + searchRevision + "]");
        System.out.println(" StorageTool [r" + storageRevision + "]");
    }

    private static void usage() {
        System.out.println("Usage: java -jar oracle.ucm.fa_client_11.1.1.jar UploadTool|DownloadTool options*");
    }
}

