/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucm.client;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.stellent.ridc.IdcClientException;
import oracle.stellent.ridc.model.DataBinder;
import oracle.stellent.ridc.model.DataObject;
import oracle.stellent.ridc.model.DataResultSet;
import oracle.stellent.ridc.protocol.ServiceResponse;
import oracle.ucm.client.AbstractTool;
import oracle.ucm.client.i18n.ClientMessages;
import oracle.ucm.client.utils.ClientUtils;
import oracle.ucm.client.utils.ProgramOptionsProcessor;
import oracle.ucm.client.utils.SearchUtils;

public class SearchTool
extends AbstractTool {
    private static final String TOOL = "Oracle WebCenter Content Document Search Utility";
    private static final String TOOL_RESTRICTIONS_OPTIONS_RESOURCE = "oracle/ucm/client/SearchTool.properties";
    private static final String TOOL_DEFAULT_OPTIONS_RESOURCE = "SearchTool.properties";

    public static void main(String[] args) {
        try {
            SearchTool tool = new SearchTool();
            try {
                boolean terminateEarly = tool.setup(args);
                if (terminateEarly) {
                    return;
                }
                SearchResults searchResults = tool.run();
            }
            catch (Exception e) {
                tool.log();
                tool.log("Error - " + e.getMessage());
                if (!tool.isSilent() && !tool.isQuiet()) {
                    tool.log(e);
                }
                throw e;
            }
            finally {
                tool.logout();
                tool.closeLog();
            }
            System.exit(0);
        }
        catch (Exception e) {
            System.exit(1);
        }
    }

    public SearchResults run() throws Exception {
        ServiceResponse response;
        String count;
        ProgramOptionsProcessor op = this.getOptionsProcessor();
        boolean ping = ClientUtils.getBooleanValue(op.get("ping", "testConnection"), false, true);
        if (ping) {
            this.ping();
            return null;
        }
        String dCollectionPath = ClientUtils.getStringIfPostTrimNonEmpty(op.get("dCollectionPath", "xCollectionPath", "collectionPath"));
        if (dCollectionPath != null) {
            String xCollectionID = this.getCollectionId(dCollectionPath);
            op.put("xCollectionID", xCollectionID);
        }
        DataBinder request = this.createServiceRequest("GET_SEARCH_RESULTS");
        boolean useSearchCache = ClientUtils.getBooleanValue(op.get("useSearchCache"), false, true);
        this.addRequestProperty(request, "UseSearchCache", useSearchCache ? "1" : "0");
        boolean triggerRowsCount = ClientUtils.getBooleanValue(op.get("triggerRowsCount", "totalRowsCount"), true, true);
        this.addRequestProperty(request, "DisableTotalItemsSearchQuery", triggerRowsCount ? "0" : "1");
        boolean allDocs = ClientUtils.getBooleanValue(op.get("allDocs"), false, true);
        if (allDocs) {
            this.addRequestProperty(request, "SearchEngineName", "DATABASE.METADATA.ALLDOCS");
        } else {
            String engine = ClientUtils.getStringIfPostTrimNonEmpty(op.get("SearchEngineName", "engine"));
            if (engine != null) {
                this.addRequestProperty(request, "SearchEngineName", engine);
            }
        }
        String queryText = ClientUtils.getStringIfPostTrimNonEmpty(op.get("QueryText"));
        if (queryText == null) {
            queryText = SearchTool.buildQueryString(op);
            this.addRequestProperty(request, "SearchQueryFormat", "UNIVERSAL");
        } else {
            String queryFormat = ClientUtils.getStringIfPostTrimNonEmpty(op.get("SearchQueryFormat"));
            this.addRequestProperty(request, "SearchQueryFormat", queryFormat == null ? "UNIVERSAL" : queryFormat);
        }
        if (queryText.length() == 0) {
            // empty if block
        }
        this.addRequestProperty(request, "QueryText", queryText);
        String sortSpec = ClientUtils.getStringIfPostTrimNonEmpty(op.get("SortSpec"));
        if (sortSpec == null) {
            String sortField = ClientUtils.getStringIfPostTrimNonEmpty(op.get("SortField"));
            String sortOrder = ClientUtils.getStringIfPostTrimNonEmpty(op.get("SortOrder"));
            if (sortField != null) {
                this.addRequestProperty(request, "SortField", sortField);
                this.addRequestProperty(request, "SortOrder", sortOrder == null ? "ASC" : sortOrder);
            }
        } else {
            this.addRequestProperty(request, "SortSpec", sortSpec);
        }
        int startRow = ClientUtils.getPositiveIntValue(op.get("StartRow"), 1);
        this.addRequestProperty(request, "StartRow", String.valueOf(startRow));
        String endRow = ClientUtils.getStringIfPostTrimNonEmpty(op.get("EndRow"));
        if (endRow != null) {
            this.addRequestProperty(request, "EndRow", String.valueOf(ClientUtils.getPositiveIntValue(endRow, 10)));
        }
        if ((count = ClientUtils.getStringIfPostTrimNonEmpty(op.get("ResultCount"))) != null) {
            this.addRequestProperty(request, "ResultCount", String.valueOf(ClientUtils.getPositiveIntValue(count, 10)));
        }
        Map<String, String> metadata = this.getCustomMetadataIfPresent(op);
        for (Map.Entry<String, String> entry : metadata.entrySet()) {
            this.addRequestProperty(request, entry.getKey(), entry.getValue());
        }
        if (this.isVerbose()) {
            this.log(ClientMessages.ucmclient_content_server_request_payload().toString());
            this.log(request);
        }
        long initial = System.currentTimeMillis();
        if (!this.isSilent() && !this.isQuiet()) {
            this.log(ClientMessages.ucmclient_performing_search().toString());
        }
        if ((response = this.sendRequest(request)) == null) {
            throw new IllegalStateException(ClientMessages.ucmclient_search_response_null_error().toExceptionString());
        }
        if (!response.getResponseType().equals((Object)ServiceResponse.ResponseType.BINDER)) {
            throw new IllegalStateException(ClientMessages.ucmclient_search_response_not_a_binder_error().toExceptionString());
        }
        DataBinder responseBinder = response.getResponseAsBinder();
        long duration = (System.currentTimeMillis() - initial) / 1000L;
        if (this.isVerbose()) {
            this.log(ClientMessages.ucmclient_search_stats(duration).toString());
            this.log();
            this.log(ClientMessages.ucmclient_content_server_response_payload().toString());
            this.log(responseBinder);
        }
        if (!this.isSilent()) {
            this.log(ClientMessages.ucmclient_search_completed().toString());
        }
        boolean padData = ClientUtils.getBooleanValue(op.get("padData", "pad"), true, true);
        boolean writeFieldHeading = ClientUtils.getBooleanValue(op.get("writeFieldHeading"), true, true);
        boolean writeFieldNames = ClientUtils.getBooleanValue(op.get("writeFieldNames"), false, true);
        boolean writeRowPrefix = ClientUtils.getBooleanValue(op.get("writeRowPrefix"), false, true);
        boolean writeRowSuffix = ClientUtils.getBooleanValue(op.get("writeRowSuffix"), false, true);
        String delim = op.get("delimiter", "delim");
        if (delim == null || delim.length() == 0) {
            delim = padData ? " " : "|";
        } else if (delim.trim().equals("\\t")) {
            delim = "\t";
        } else if (delim.trim().equals("\\n")) {
            delim = "\n";
        }
        String rowprefix = op.get("rowprefix");
        if (rowprefix == null) {
            rowprefix = "[";
        } else if (rowprefix.trim().equals("\\t")) {
            rowprefix = "\t";
        } else if (rowprefix.trim().equals("\\n")) {
            rowprefix = "\n";
        }
        String rowsufix = op.get("rowsuffix");
        if (rowsufix == null) {
            rowsufix = "]";
        } else if (rowsufix.trim().equals("\\t")) {
            rowsufix = "\t";
        } else if (rowsufix.trim().equals("\\n")) {
            rowsufix = "\n";
        }
        boolean showDefaultFields = ClientUtils.getBooleanValue(op.get("defaultFields"), true, true);
        boolean showMoreFields = ClientUtils.getBooleanValue(op.get("moreFields", "more"), false, true);
        LinkedHashMap<String, ClientUtils.Pad> fields = new LinkedHashMap<String, ClientUtils.Pad>();
        if (showMoreFields) {
            fields.put("dID", new ClientUtils.Leftpad(10));
            fields.put("dDocName", new ClientUtils.Rightpad(25));
            fields.put("dDocTitle", new ClientUtils.Rightpad(35));
            fields.put("dOriginalName", new ClientUtils.Rightpad(35));
            fields.put("VaultFileSize", new ClientUtils.LeftpadPlus(10, "Size"));
            fields.put("dDocLastModifiedDate", new ClientUtils.Rightpad(20));
            fields.put("dDocLastModifier", new ClientUtils.Rightpad(20));
            fields.put("dSecurityGroup", new ClientUtils.Rightpad(20));
            fields.put("dDocAccount", new ClientUtils.Rightpad(30));
            fields.put("xStorageRule", new ClientUtils.Rightpad(17));
        } else if (showDefaultFields) {
            fields.put("dID", new ClientUtils.Leftpad(8));
            fields.put("dDocName", new ClientUtils.Rightpad(22));
            fields.put("dDocTitle", new ClientUtils.Rightpad(26));
            fields.put("dDocLastModifiedDate", new ClientUtils.RightpadPlus(10, "Modified"));
            fields.put("dDocLastModifier", new ClientUtils.RightpadPlus(8, "Modifer"));
        }
        String outputFields = ClientUtils.getStringIfPostTrimNonEmpty(op.get("fields", "outputFields"));
        if (outputFields != null) {
            String[] fieldsUnprocessed = outputFields.split(",");
            for (int i = 0; i < fieldsUnprocessed.length; ++i) {
                String field = fieldsUnprocessed[i];
                if (field == null || field.trim().length() <= 0) continue;
                String f = field.trim();
                String expr = "^(.+)#(l|r)(\\d+)$";
                Pattern pattern = Pattern.compile(expr, 2);
                Matcher matcher = pattern.matcher(f);
                if (matcher.matches()) {
                    f = matcher.group(1);
                    int size = Integer.valueOf(matcher.group(3));
                    fields.put(f, "l".equalsIgnoreCase(matcher.group(2)) ? new ClientUtils.Leftpad(size) : new ClientUtils.Rightpad(size));
                    continue;
                }
                fields.put(f, null);
            }
        }
        if (writeFieldHeading) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry entry : fields.entrySet()) {
                String field = (String)entry.getKey();
                ClientUtils.Pad p = (ClientUtils.Pad)entry.getValue();
                if (sb.length() > 0) {
                    sb.append(delim);
                } else if (writeRowPrefix) {
                    sb.append(rowprefix);
                }
                if (!padData || p == null) {
                    sb.append(field);
                    continue;
                }
                if (p instanceof ClientUtils.Leftpad) {
                    sb.append(ClientUtils.leftPad(p instanceof ClientUtils.LeftpadPlus ? ((ClientUtils.LeftpadPlus)p).getHeader() : field, p.getSize()));
                    continue;
                }
                sb.append(ClientUtils.rightPad(p instanceof ClientUtils.RightpadPlus ? ((ClientUtils.RightpadPlus)p).getHeader() : field, p.getSize()));
            }
            if (writeRowSuffix) {
                sb.append(rowsufix);
            }
            if (!this.isSilent()) {
                this.log(sb.toString());
            }
        }
        DataResultSet resultSet = responseBinder.getResultSet("SearchResults");
        ArrayList<SearchResult> searchResults = new ArrayList<SearchResult>(resultSet.getRows().size());
        for (DataObject dataObject : resultSet.getRows()) {
            SearchResult result = new SearchResult();
            result.setDID((String)dataObject.get("dID"));
            result.setDDocName((String)dataObject.get("dDocName"));
            result.setDDocTitle((String)dataObject.get("dDocTitle"));
            result.setDOriginalName((String)dataObject.get("dOriginalName"));
            result.setVaultFileSize((String)dataObject.get("VaultFileSize"));
            result.setDDocLastModifiedDate((String)dataObject.get("dDocLastModifiedDate"));
            result.setDDocLastModifier((String)dataObject.get("dDocLastModifier"));
            result.setDSecurityGroup((String)dataObject.get("dSecurityGroup"));
            result.setDDocAccount((String)dataObject.get("dDocAccount"));
            result.setXStorageRule((String)dataObject.get("xStorageRule"));
            searchResults.add(result);
            StringBuilder sb = new StringBuilder();
            for (Map.Entry entry : fields.entrySet()) {
                String field = (String)entry.getKey();
                ClientUtils.Pad p = (ClientUtils.Pad)entry.getValue();
                if (sb.length() > 0) {
                    sb.append(delim);
                } else if (writeRowPrefix) {
                    sb.append(rowprefix);
                }
                String value = (String)dataObject.get(field);
                if (padData && p != null) {
                    String string = value = p instanceof ClientUtils.Leftpad ? ClientUtils.leftPad(value, p.getSize()) : ClientUtils.rightPad(value, p.getSize());
                }
                if (writeFieldNames) {
                    sb.append(field).append("=").append(value);
                    continue;
                }
                sb.append(value);
            }
            if (writeRowSuffix) {
                sb.append(rowsufix);
            }
            if (this.isSilent()) continue;
            this.log(sb.toString());
        }
        int totalRows = ClientUtils.getIntValue(responseBinder.getLocal("TotalRows"), -1);
        boolean writeResultCountStats = ClientUtils.getBooleanValue(op.get("writeCounts"), true, true);
        if (!this.isSilent() && writeResultCountStats) {
            this.log(ClientMessages.ucmclient_search_resultcounts(resultSet.getRows().size(), totalRows).toString());
        }
        SearchResults results = new SearchResults();
        results.setDuration(duration);
        results.setResults(searchResults);
        results.setQueryText(queryText);
        results.setTotalRows(totalRows);
        return results;
    }

    private static String buildQueryString(ProgramOptionsProcessor op) {
        StringBuilder queryBuilder = new StringBuilder();
        SearchUtils.processDateNumberQueryParam(op, queryBuilder, "dID");
        SearchUtils.processDateNumberQueryParam(op, queryBuilder, "dRevisionID", "revision");
        SearchUtils.processStringQueryParam(op, queryBuilder, "dDocName");
        SearchUtils.processStringQueryParam(op, queryBuilder, false, false, "dDocTitle", "title");
        SearchUtils.processStringQueryParam(op, queryBuilder, false, false, "dOriginalName", "name");
        SearchUtils.processStringQueryParam(op, queryBuilder, false, true, "dExtension", "ext");
        SearchUtils.processStringQueryParam(op, queryBuilder, false, true, "xComments", "comments");
        SearchUtils.processStringQueryParam(op, queryBuilder, "xStorageRule", "provider");
        SearchUtils.processDateNumberQueryParam(op, queryBuilder, "dFileSize", "size");
        SearchUtils.processDateNumberQueryParam(op, queryBuilder, "dDocCreatedDate", "created", "createDate");
        SearchUtils.processDateNumberQueryParam(op, queryBuilder, "dDocLastModifiedDate", "modified", "lastModified", "lastModifiedDate");
        SearchUtils.processDateNumberQueryParam(op, queryBuilder, "dInDate", "released", "releaseDate");
        SearchUtils.processStringQueryParam(op, queryBuilder, "dDocType", "type");
        SearchUtils.processStringQueryParam(op, queryBuilder, "dFormat", "format");
        SearchUtils.processStringQueryParam(op, queryBuilder, "dDocAuthor", "author");
        SearchUtils.processStringQueryParam(op, queryBuilder, "dSecurityGroup", "group");
        SearchUtils.processStringQueryParam(op, queryBuilder, true, true, "dDocAccount", "account");
        SearchUtils.processStringQueryParam(op, queryBuilder, "dDocCreator", "creator");
        SearchUtils.processStringQueryParam(op, queryBuilder, "dDocLastModifier", "modifier", "lastModifier");
        SearchUtils.processDateNumberQueryParam(op, queryBuilder, "xCollectionID", "dCollectionID", "collectionID");
        String queryText = queryBuilder.toString();
        return queryText;
    }

    protected String getCollectionId(String dCollectionPath) throws IdcClientException {
        ServiceResponse response;
        String service = "COLLECTION_GET_COLLECTION";
        DataBinder request = this.createServiceRequest(service);
        this.addRequestProperty(request, "hasCollectionPath", "true");
        this.addRequestProperty(request, "dCollectionPath", dCollectionPath);
        if (this.isVerbose()) {
            this.log(ClientMessages.ucmclient_content_server_request_payload().toString());
            this.log(request);
        }
        if ((response = this.sendRequest(request)) == null || !response.getResponseType().equals((Object)ServiceResponse.ResponseType.BINDER)) {
            throw new IllegalStateException(ClientMessages.ucmclient_invalid_response_error(service).toExceptionString());
        }
        DataBinder responseBinder = response.getResponseAsBinder();
        if (this.isVerbose()) {
            this.log();
            this.log(ClientMessages.ucmclient_content_server_response_payload().toString());
            this.log(responseBinder);
        }
        DataResultSet resultSet = responseBinder.getResultSet("COLLECTION");
        DataObject dataObject = resultSet.getRows().get(0);
        String collectionID = (String)dataObject.get("dCollectionID");
        return collectionID;
    }

    protected String getToolClassAndRevision() {
        String revision = ClientUtils.getRevision(SearchTool.idcVersionInfo(null));
        String parentRevision = ClientUtils.getRevision(AbstractTool.idcVersionInfo(null));
        return "SearchTool" + (revision != null && revision.length() > 0 ? " [r" + revision + "]/[p" + parentRevision + "]" : "");
    }

    protected String getUsage() {
        return ClientMessages.ucmclient_search_usage().toString();
    }

    protected String getToolHeader() {
        return TOOL;
    }

    protected String getToolRestrictionsOptionsResource() {
        return TOOL_RESTRICTIONS_OPTIONS_RESOURCE;
    }

    protected String getToolDefaultOptionsResource() {
        return TOOL_DEFAULT_OPTIONS_RESOURCE;
    }

    public static Object idcVersionInfo(Object arg) {
        return "releaseInfo=dev,releaseRevision=$Rev: 128389 $";
    }

    public static class SearchResult {
        private String m_dID;
        private String m_dDocName;
        private String m_dDocTitle;
        private String m_dOriginalName;
        private String m_VaultFileSize;
        private String m_dDocLastModifiedDate;
        private String m_dDocLastModifier;
        private String m_dSecurityGroup;
        private String m_dDocAccount;
        private String m_xStorageRule;

        protected void setDID(String dID) {
            this.m_dID = dID;
        }

        public String getDID() {
            return this.m_dID;
        }

        protected void setDDocName(String dDocName) {
            this.m_dDocName = dDocName;
        }

        public String getDDocName() {
            return this.m_dDocName;
        }

        protected void setDDocTitle(String dDocTitle) {
            this.m_dDocTitle = dDocTitle;
        }

        public String getDDocTitle() {
            return this.m_dDocTitle;
        }

        protected void setDOriginalName(String dOriginalName) {
            this.m_dOriginalName = dOriginalName;
        }

        public String getDOriginalName() {
            return this.m_dOriginalName;
        }

        protected void setVaultFileSize(String VaultFileSize) {
            this.m_VaultFileSize = VaultFileSize;
        }

        public String getVaultFileSize() {
            return this.m_VaultFileSize;
        }

        protected void setDDocLastModifiedDate(String dDocLastModifiedDate) {
            this.m_dDocLastModifiedDate = dDocLastModifiedDate;
        }

        public String getDDocLastModifiedDate() {
            return this.m_dDocLastModifiedDate;
        }

        protected void setDDocLastModifier(String dDocLastModifier) {
            this.m_dDocLastModifier = dDocLastModifier;
        }

        public String getDDocLastModifier() {
            return this.m_dDocLastModifier;
        }

        protected void setDSecurityGroup(String dSecurityGroup) {
            this.m_dSecurityGroup = dSecurityGroup;
        }

        public String getDSecurityGroup() {
            return this.m_dSecurityGroup;
        }

        protected void setDDocAccount(String dDocAccount) {
            this.m_dDocAccount = dDocAccount;
        }

        public String getDDocAccount() {
            return this.m_dDocAccount;
        }

        protected void setXStorageRule(String xStorageRule) {
            this.m_xStorageRule = xStorageRule;
        }

        public String getXStorageRule() {
            return this.m_xStorageRule;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SearchResults {
        private ArrayList<SearchResult> m_results;
        private long m_duration;
        private String m_queryText;
        private int m_totalRows;

        protected void setDuration(long duration) {
            this.m_duration = duration;
        }

        public long getDuration() {
            return this.m_duration;
        }

        public int getResultCount() {
            return this.m_results == null ? 0 : this.m_results.size();
        }

        protected void setResults(ArrayList<SearchResult> results) {
            this.m_results = results;
        }

        public ArrayList<SearchResult> getResults() {
            return this.m_results;
        }

        protected void setQueryText(String queryText) {
            this.m_queryText = queryText;
        }

        public String getQueryText() {
            return this.m_queryText;
        }

        protected void setTotalRows(int totalRows) {
            this.m_totalRows = totalRows;
        }

        public int getTotalRows() {
            return this.m_totalRows;
        }
    }
}

