/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucm.client;

import oracle.stellent.ridc.IdcClientException;
import oracle.stellent.ridc.model.DataBinder;
import oracle.stellent.ridc.model.DataObject;
import oracle.stellent.ridc.model.DataResultSet;
import oracle.stellent.ridc.protocol.ServiceResponse;
import oracle.ucm.client.AbstractTool;
import oracle.ucm.client.i18n.ClientMessages;
import oracle.ucm.client.utils.ClientUtils;
import oracle.ucm.client.utils.ProgramOptionsProcessor;
import oracle.ucm.client.utils.SearchUtils;

public class StorageTool
extends AbstractTool {
    private static final String TOOL = "Oracle WebCenter Content Storage Migration Utility";
    private static final String TOOL_RESTRICTIONS_OPTIONS_RESOURCE = "oracle/ucm/client/StorageTool.properties";
    private static final String TOOL_DEFAULT_OPTIONS_RESOURCE = "StorageTool.properties";

    public static void main(String[] args) {
        StorageTool d = new StorageTool();
        try {
            d.run(args);
            System.exit(0);
        }
        catch (Exception e) {
            System.exit(1);
        }
    }

    public void run(String[] args) throws Exception {
        try {
            ServiceResponse response;
            String count;
            boolean terminateEarly = this.setup(args);
            if (terminateEarly) {
                return;
            }
            ProgramOptionsProcessor op = this.getOptionsProcessor();
            boolean ping = ClientUtils.getBooleanValue(op.get("ping", "testConnection"), false, true);
            if (ping) {
                this.ping();
                return;
            }
            String targetStorageRule = ClientUtils.getStringIfPostTrimNonEmpty(op.get("target", "targetRule", "targetStorageRule", "storageRule"));
            if (targetStorageRule == null) {
                targetStorageRule = "FusionStorageRule";
            }
            if (!this.verifyStorageRule(op, targetStorageRule)) {
                throw new Exception(ClientMessages.ucmclient_storagemigration_invalidrule(targetStorageRule).toExceptionString());
            }
            if (!this.isSilent() && !this.isQuiet()) {
                this.log(ClientMessages.ucmclient_storagemigration_goodrule(targetStorageRule).toString());
            }
            if (!this.isSilent() && !this.isQuiet()) {
                this.log(ClientMessages.ucmclient_storagemigration_searching().toString());
            }
            boolean dryRun = ClientUtils.getBooleanValue(op.get("dryRun"), true, true);
            boolean bypassReindexingAndRefinery = !ClientUtils.getBooleanValue(op.get("reindex"), false, true);
            boolean abortOnFirstFailure = ClientUtils.getBooleanValue(op.get("abortOnFirstFailure", "abortOnFailure"), false, true);
            DataBinder request = this.createServiceRequest("GET_SEARCH_RESULTS");
            boolean allDocs = ClientUtils.getBooleanValue(op.get("allDocs"), true, true);
            if (allDocs) {
                this.addRequestProperty(request, "SearchEngineName", "DATABASE.METADATA.ALLDOCS");
            } else {
                String engine = ClientUtils.getStringIfPostTrimNonEmpty(op.get("SearchEngineName", "engine"));
                if (engine != null) {
                    this.addRequestProperty(request, "SearchEngineName", engine);
                }
            }
            String queryText = ClientUtils.getStringIfPostTrimNonEmpty(op.get("QueryText"));
            if (queryText == null) {
                queryText = StorageTool.buildQueryString(op);
                if (queryText.length() == 0) {
                    queryText = "(<NOT> (xStorageRule <matches> `" + targetStorageRule + "`))";
                }
                this.addRequestProperty(request, "SearchQueryFormat", "UNIVERSAL");
            } else {
                String queryFormat = ClientUtils.getStringIfPostTrimNonEmpty(op.get("SearchQueryFormat"));
                this.addRequestProperty(request, "SearchQueryFormat", queryFormat == null ? "UNIVERSAL" : queryFormat);
            }
            this.addRequestProperty(request, "QueryText", queryText);
            String sortSpec = ClientUtils.getStringIfPostTrimNonEmpty(op.get("SortSpec"));
            if (sortSpec == null) {
                String sortField = ClientUtils.getStringIfPostTrimNonEmpty(op.get("SortField"));
                String sortOrder = ClientUtils.getStringIfPostTrimNonEmpty(op.get("SortOrder"));
                if (sortField != null) {
                    this.addRequestProperty(request, "SortField", sortField);
                    this.addRequestProperty(request, "SortOrder", sortOrder == null ? "ASC" : sortOrder);
                }
            } else {
                this.addRequestProperty(request, "SortSpec", sortSpec);
            }
            int startRow = ClientUtils.getPositiveIntValue(op.get("StartRow"), 1);
            this.addRequestProperty(request, "StartRow", String.valueOf(startRow));
            String endRow = ClientUtils.getStringIfPostTrimNonEmpty(op.get("EndRow"));
            if (endRow != null) {
                this.addRequestProperty(request, "EndRow", String.valueOf(ClientUtils.getPositiveIntValue(endRow, 10)));
            }
            if ((count = ClientUtils.getStringIfPostTrimNonEmpty(op.get("ResultCount"))) != null) {
                this.addRequestProperty(request, "ResultCount", String.valueOf(ClientUtils.getPositiveIntValue(count, 10)));
            }
            if (this.isVerbose()) {
                this.log(ClientMessages.ucmclient_content_server_request_payload().toString());
                this.log(request);
            }
            long initial = System.currentTimeMillis();
            if (this.isVerbose()) {
                this.log(ClientMessages.ucmclient_performing_search().toString());
            }
            if ((response = this.sendRequest(request)) == null) {
                throw new IllegalStateException(ClientMessages.ucmclient_search_response_null_error().toExceptionString());
            }
            if (!response.getResponseType().equals((Object)ServiceResponse.ResponseType.BINDER)) {
                throw new IllegalStateException(ClientMessages.ucmclient_search_response_not_a_binder_error().toExceptionString());
            }
            DataBinder responseBinder = response.getResponseAsBinder();
            long duration = (System.currentTimeMillis() - initial) / 1000L;
            if (this.isVerbose()) {
                this.log(ClientMessages.ucmclient_search_stats(duration).toString());
                this.log();
                this.log(ClientMessages.ucmclient_content_server_response_payload().toString());
                this.log(responseBinder);
            }
            if (this.isVerbose()) {
                this.log(ClientMessages.ucmclient_search_completed().toString());
            }
            int processed = 0;
            int skipped = 0;
            int migrated = 0;
            int failed = 0;
            DataResultSet resultSet = responseBinder.getResultSet("SearchResults");
            int totalRows = ClientUtils.getIntValue(responseBinder.getLocal("TotalRows"), -1);
            if (!this.isSilent() && !this.isQuiet()) {
                this.log(ClientMessages.ucmclient_storagemigration_searchresultcounts_batchdetails(resultSet.getRows().size(), totalRows).toString());
            }
            for (DataObject dataObject : resultSet.getRows()) {
                String storageRule;
                ++processed;
                String dID = (String)dataObject.get("dID");
                String dDocName = (String)dataObject.get("dDocName");
                String xStorageRule = (String)dataObject.get("xStorageRule");
                String dDocLastModifiedDate = (String)dataObject.get("dDocLastModifiedDate");
                if (targetStorageRule.equals(xStorageRule)) {
                    ++skipped;
                    if (this.isSilent() || this.isQuiet()) continue;
                    this.log(ClientMessages.ucmclient_storagemigration_skipped(dID).toString());
                    continue;
                }
                if (dryRun) {
                    ++migrated;
                    if (this.isSilent() || this.isQuiet()) continue;
                    this.log(ClientMessages.ucmclient_storagemigration_candidate(dID).toString());
                    continue;
                }
                if (!this.isSilent() && !this.isQuiet()) {
                    this.log(ClientMessages.ucmclient_performing_storagemigration(dID).toString());
                }
                DataBinder migrationBinder = this.createServiceRequest("UPDATE_DOCINFO");
                this.addRequestProperty(migrationBinder, "dID", dID);
                this.addRequestProperty(migrationBinder, "dDocName", dDocName);
                this.addRequestProperty(migrationBinder, "xStorageRule", targetStorageRule);
                if (bypassReindexingAndRefinery) {
                    this.addRequestProperty(migrationBinder, "addReleasedWebFile", "TRUE");
                }
                if (this.isVerbose()) {
                    this.log(ClientMessages.ucmclient_content_server_request_payload().toString());
                    this.log(migrationBinder);
                }
                initial = System.currentTimeMillis();
                ServiceResponse migrationResponse = this.sendRequest(migrationBinder);
                if (migrationResponse == null) {
                    throw new IllegalStateException(ClientMessages.ucmclient_storagemigration_response_null_error().toExceptionString());
                }
                if (!migrationResponse.getResponseType().equals((Object)ServiceResponse.ResponseType.BINDER)) {
                    throw new IllegalStateException(ClientMessages.ucmclient_storagemigration_response_not_a_binder_error().toExceptionString());
                }
                DataBinder migrationResponseBinder = migrationResponse.getResponseAsBinder();
                duration = (System.currentTimeMillis() - initial) / 1000L;
                if (this.isVerbose()) {
                    this.log(ClientMessages.ucmclient_storagemigration_stats(dID, duration).toString());
                    this.log();
                    this.log(ClientMessages.ucmclient_content_server_response_payload().toString());
                    this.log(migrationResponseBinder);
                }
                if (targetStorageRule.equals(storageRule = migrationResponseBinder.getLocal("xStorageRule"))) {
                    ++migrated;
                    if (!this.isVerbose()) continue;
                    this.log(ClientMessages.ucmclient_storagemigration_successful().toString());
                    continue;
                }
                ++failed;
                if (!this.isVerbose()) continue;
                this.log(ClientMessages.ucmclient_storagemigration_failed(dID).toString());
            }
            if (dryRun) {
                this.log(ClientMessages.ucmclient_storagemigration_dryrun_result(processed, migrated, skipped).toString());
            } else {
                this.log(ClientMessages.ucmclient_storagemigration_result(processed, failed, migrated, skipped).toString());
            }
            return;
        }
        catch (Exception e) {
            this.log("\nError - " + e.getMessage());
            if (!this.isSilent() && !this.isQuiet()) {
                this.log(e);
            }
            throw e;
        }
        finally {
            this.logout();
            this.closeLog();
        }
    }

    private boolean verifyStorageRule(ProgramOptionsProcessor op, String targetStorageRule) throws IdcClientException {
        ServiceResponse response;
        String providerName = ClientUtils.getStringIfPostTrimNonEmpty(op.get("provider", "providerName"));
        if (providerName == null) {
            providerName = "DefaultFileStore";
        }
        DataBinder request = this.createServiceRequest("FS_GET_STORAGE_RULE");
        this.addRequestProperty(request, "pName", providerName);
        if (this.isVerbose()) {
            this.log(ClientMessages.ucmclient_content_server_request_payload().toString());
            this.log(request);
        }
        if ((response = this.sendRequest(request)) == null || !response.getResponseType().equals((Object)ServiceResponse.ResponseType.BINDER)) {
            throw new IllegalStateException(ClientMessages.ucmclient_invalid_response_error("FS_GET_STORAGE_RULE").toExceptionString());
        }
        DataBinder responseBinder = response.getResponseAsBinder();
        if (this.isVerbose()) {
            this.log();
            this.log(ClientMessages.ucmclient_content_server_response_payload().toString());
            this.log(responseBinder);
        }
        boolean existingRule = false;
        DataResultSet resultSet = responseBinder.getResultSet("StorageRules");
        for (DataObject dataObject : resultSet.getRows()) {
            if (!targetStorageRule.equals(dataObject.get("StorageRule"))) continue;
            existingRule = true;
            break;
        }
        return existingRule;
    }

    private static String buildQueryString(ProgramOptionsProcessor op) {
        StringBuilder queryBuilder = new StringBuilder();
        SearchUtils.processDateNumberQueryParam(op, queryBuilder, "dID");
        SearchUtils.processStringQueryParam(op, queryBuilder, "dDocName");
        SearchUtils.processStringQueryParam(op, queryBuilder, "xStorageRule", "provider");
        SearchUtils.processDateNumberQueryParam(op, queryBuilder, "dFileSize", "size");
        SearchUtils.processDateNumberQueryParam(op, queryBuilder, "dDocCreatedDate", "created", "createDate");
        SearchUtils.processDateNumberQueryParam(op, queryBuilder, "dDocLastModifiedDate", "modified", "lastModified", "lastModifiedDate");
        SearchUtils.processDateNumberQueryParam(op, queryBuilder, "dInDate", "released", "releaseDate");
        SearchUtils.processStringQueryParam(op, queryBuilder, "dSecurityGroup", "group");
        String queryText = queryBuilder.toString();
        return queryText;
    }

    protected String getToolClassAndRevision() {
        String revision = ClientUtils.getRevision(StorageTool.idcVersionInfo(null));
        String parentRevision = ClientUtils.getRevision(AbstractTool.idcVersionInfo(null));
        return "StorageTool" + (revision != null && revision.length() > 0 ? " [r" + revision + "]/[p" + parentRevision + "]" : "");
    }

    protected String getUsage() {
        return ClientMessages.ucmclient_storage_usage().toString();
    }

    protected String getToolHeader() {
        return TOOL;
    }

    protected String getToolRestrictionsOptionsResource() {
        return TOOL_RESTRICTIONS_OPTIONS_RESOURCE;
    }

    protected String getToolDefaultOptionsResource() {
        return TOOL_DEFAULT_OPTIONS_RESOURCE;
    }

    public static Object idcVersionInfo(Object arg) {
        return "releaseInfo=dev,releaseRevision=$Rev: 128389 $";
    }
}

