/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucm.client;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import oracle.stellent.ridc.model.DataBinder;
import oracle.stellent.ridc.model.TransferFile;
import oracle.stellent.ridc.protocol.ServiceException;
import oracle.stellent.ridc.protocol.ServiceResponse;
import oracle.ucm.client.AbstractTool;
import oracle.ucm.client.bulk.ExecutorMonitor;
import oracle.ucm.client.bulk.UploadException;
import oracle.ucm.client.bulk.UploadThread;
import oracle.ucm.client.i18n.ClientMessages;
import oracle.ucm.client.model.content.CheckinSource;
import oracle.ucm.client.model.content.impl.LocalFileCheckinSource;
import oracle.ucm.client.model.response.CheckinResponse;
import oracle.ucm.client.utils.ClientUtils;
import oracle.ucm.client.utils.ProgramOptionsProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadTool
extends AbstractTool {
    private static final String TOOL = "Oracle WebCenter Content Document Transfer Utility";
    private static final String TOOL_RESTRICTIONS_OPTIONS_RESOURCE = "oracle/ucm/client/UploadTool.properties";
    private static final String TOOL_DEFAULT_OPTIONS_RESOURCE = "UploadTool.properties";
    private static final String ALTERNATE_AUTO_GENERATED_STRING = "This file was auto-generated; Please utilize native / primary file.";
    private static final String ACCOUNT_REQUIRED = "Tool.AccountRequired";
    private static final String ACCOUNT_TRANSFORMED = "Tool.AccountTransformed";
    private List<CheckinSource> m_checkinItems = null;

    public static void main(String[] args) {
        try {
            UploadTool tool = new UploadTool();
            try {
                boolean terminateEarly = tool.setup(args);
                if (terminateEarly) {
                    return;
                }
                UploadResults uploadResults = tool.run();
            }
            catch (Exception e) {
                tool.log();
                tool.log("Error - " + e.getMessage());
                if (!tool.isSilent() && !tool.isQuiet()) {
                    tool.log(e);
                }
                throw e;
            }
            finally {
                tool.logout();
                tool.closeLog();
            }
            System.exit(0);
        }
        catch (Exception e) {
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UploadResults run() throws Exception {
        ProgramOptionsProcessor op = this.getOptionsProcessor();
        boolean ping = ClientUtils.getBooleanValue(op.get("ping", "testConnection"), false, true);
        boolean multiUpload = false;
        List<CheckinSource> checkinItems = this.getCheckinItems();
        if (checkinItems != null) {
            multiUpload = true;
        } else {
            CheckinSource item = this.processLocalFileIfSpecified();
            if (item != null) {
                multiUpload = false;
                checkinItems = new ArrayList<CheckinSource>(1);
                checkinItems.add(item);
            } else {
                List<CheckinSource> items = this.processLocalDirectoryIfSpecified();
                if (items != null) {
                    multiUpload = true;
                    checkinItems = items;
                }
            }
        }
        if (ping || checkinItems == null) {
            this.ping();
            return null;
        }
        LinkedHashMap<Integer, CheckinResponse> successfulCheckinsKeyedByTaskNum = new LinkedHashMap<Integer, CheckinResponse>();
        LinkedHashMap<String, CheckinResponse> successfulCheckinsKeyedByIdentifier = new LinkedHashMap<String, CheckinResponse>();
        LinkedHashMap<Integer, Exception> allFailedCheckinsKeyedByTaskNum = new LinkedHashMap<Integer, Exception>();
        LinkedHashMap<Integer, UploadException> failedCheckinsKeyedByTaskNum = new LinkedHashMap<Integer, UploadException>();
        LinkedHashMap<String, UploadException> failedCheckinsKeyedByIdentifier = new LinkedHashMap<String, UploadException>();
        UploadResults results = new UploadResults(successfulCheckinsKeyedByTaskNum, successfulCheckinsKeyedByIdentifier, allFailedCheckinsKeyedByTaskNum, failedCheckinsKeyedByTaskNum, failedCheckinsKeyedByIdentifier);
        if (!multiUpload) {
            CheckinSource source = checkinItems.get(0);
            try {
                ServiceResponse response;
                TransferFile alternate;
                String dDocName = source.getDDocName();
                this.performCheckoutIfRequested(op, dDocName);
                Map<String, String> metadata = this.getCustomMetadataIfPresent(op);
                DataBinder request = this.createServiceRequest("CHECKIN_UNIVERSAL");
                if (dDocName != null) {
                    this.addRequestProperty(request, "dDocName", dDocName);
                }
                this.addRequestProperty(request, "dSecurityGroup", source.getDSecurityGroup());
                this.addRequestProperty(request, "dDocAccount", source.getDDocAccount());
                this.addRequestProperty(request, "dDocType", source.getDDocType());
                this.addRequestProperty(request, "dDocTitle", source.getDDocTitle());
                boolean progressBar = !this.isSilent() && ClientUtils.getBooleanValue(op.get("progress", "progressBar"), false, true);
                TransferFile.TransferProgress priProgress = null;
                TransferFile.TransferProgress altProgress = null;
                TransferFile primary = source.getPrimaryFile();
                request.addFile("primaryFile", primary);
                if (source.getPrimaryFileCharacterSet() != null) {
                    this.addRequestProperty(request, "primaryFile:dCharacterSet", source.getPrimaryFileCharacterSet());
                }
                if (source.getPrimaryFileLanguage() != null) {
                    this.addRequestProperty(request, "primaryFile:dLanguage", source.getPrimaryFileLanguage());
                }
                if (progressBar) {
                    TransferFile transferFile = primary;
                    transferFile.getClass();
                    priProgress = new TransferFile.TransferProgress(transferFile, primary.getContentLength());
                    primary.setTransferListener(priProgress);
                }
                if ((alternate = source.getAlternateFile()) != null) {
                    request.addFile("alternateFile", alternate);
                    if (source.getAlternateFileCharacterSet() != null) {
                        this.addRequestProperty(request, "alternateFile:dCharacterSet", source.getAlternateFileCharacterSet());
                    }
                    if (source.getAlternateFileLanguage() != null) {
                        this.addRequestProperty(request, "alternateFile:dLanguage", source.getAlternateFileLanguage());
                    }
                    if (progressBar) {
                        TransferFile transferFile = alternate;
                        transferFile.getClass();
                        altProgress = new TransferFile.TransferProgress(transferFile, alternate.getContentLength());
                        alternate.setTransferListener(altProgress);
                    }
                }
                for (Map.Entry<String, String> entry : metadata.entrySet()) {
                    this.addRequestProperty(request, entry.getKey(), entry.getValue());
                }
                if (this.isVerbose()) {
                    this.log();
                    this.log(ClientMessages.ucmclient_content_server_request_payload().toString());
                    this.log(request);
                }
                long initial = System.currentTimeMillis();
                if (!this.isSilent() && !this.isQuiet()) {
                    this.log(ClientMessages.ucmclient_performing_upload().toString());
                }
                if (progressBar) {
                    final TransferFile.TransferProgress primaryProgress = priProgress;
                    final TransferFile.TransferProgress alternateProgress = altProgress;
                    new Thread(new Runnable(){

                        public void run() {
                            UploadTool.this.log("upload progress % |0-10-20-30-40-50-60-70-80-90-100|");
                            UploadTool.this.print("   primary file    ^");
                            this.logProgress(primaryProgress);
                            if (alternateProgress != null) {
                                UploadTool.this.print(" alternate file    ^");
                                this.logProgress(alternateProgress);
                            }
                            UploadTool.this.log("Server processing request, please wait ...");
                        }

                        private void logProgress(TransferFile.TransferProgress progress) {
                            int lastPercentRendered = 0;
                            block2: while (true) {
                                try {
                                    int percent;
                                    do {
                                        Thread.sleep(250L);
                                        percent = progress.getTransferPercentage();
                                        if (percent == -1) {
                                            UploadTool.this.log(" NOT SUPPORTED");
                                            break block2;
                                        }
                                        if (percent == lastPercentRendered) continue;
                                        int blocksToRender = (percent - lastPercentRendered) / 5;
                                        for (int i = 0; i < blocksToRender; ++i) {
                                            UploadTool.this.print((lastPercentRendered += 5) % 10 == 0 ? "^^" : "^");
                                        }
                                    } while (100 != percent);
                                    UploadTool.this.log("^");
                                }
                                catch (InterruptedException interruptedException) {
                                    continue;
                                }
                                break;
                            }
                        }
                    }).start();
                }
                if ((response = this.sendRequest(request)) == null) {
                    throw new IllegalStateException(ClientMessages.ucmclient_upload_response_null_error().toExceptionString());
                }
                if (!response.getResponseType().equals((Object)ServiceResponse.ResponseType.BINDER)) {
                    throw new IllegalStateException(ClientMessages.ucmclient_upload_response_not_a_binder_error().toExceptionString());
                }
                DataBinder responseBinder = response.getResponseAsBinder();
                String dID = responseBinder.getLocal("dID");
                dDocName = responseBinder.getLocal("dDocName");
                long duration = (System.currentTimeMillis() - initial) / 1000L;
                if (progressBar) {
                    Thread.sleep(550L);
                }
                if (this.isVerbose()) {
                    this.log(ClientMessages.ucmclient_upload_stats(duration).toString());
                    this.log();
                    this.log(ClientMessages.ucmclient_content_server_response_payload().toString());
                    this.log(responseBinder);
                }
                if (!this.isSilent()) {
                    this.log(ClientMessages.ucmclient_upload_successful().toString());
                    this.log("[dID=" + dID + " | dDocName=" + dDocName + "]");
                }
                String string = responseBinder.getLocal("dDocTitle");
                String dOriginalName = responseBinder.getLocal("dOriginalName");
                long dFileSize = new Long(responseBinder.getLocal("dFileSize"));
                CheckinResponse checkinResponse = new CheckinResponse(source.getIdentifier(), 0, dID, dDocName, string, dOriginalName, dFileSize, duration);
                successfulCheckinsKeyedByTaskNum.put(0, checkinResponse);
                successfulCheckinsKeyedByIdentifier.put(source.getIdentifier(), checkinResponse);
            }
            finally {
                source.closePrimaryFile();
                source.closeAlternateFile();
            }
        }
        if (multiUpload) {
            Map<String, String> metadata = this.getCustomMetadataIfPresent(op);
            int queueSize = checkinItems.size();
            int workers = ClientUtils.getPositiveIntValue(op.get("threads", "workers"), 4);
            boolean throwAtCompletionOnThreadException = ClientUtils.getBooleanValue(op.get("throwOnThreadException", "throwAtCompletionOnThreadException"), true, true);
            ThreadFactory threadFactory = Executors.defaultThreadFactory();
            ThreadPoolExecutor pool = new ThreadPoolExecutor(workers, workers, 1L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(queueSize), threadFactory);
            ArrayList<Future<CheckinResponse>> futures = new ArrayList<Future<CheckinResponse>>(queueSize);
            ExecutorMonitor monitor = null;
            Thread monitorThread = null;
            if (this.isVerbose()) {
                int monitorInterval = 60;
                monitor = new ExecutorMonitor(pool, monitorInterval, this.getLogger());
                monitorThread = new Thread(monitor);
                monitorThread.start();
            }
            long initial = System.currentTimeMillis();
            int taskNumber = 0;
            for (CheckinSource source : checkinItems) {
                UploadThread worker = new UploadThread(taskNumber++, this, source, metadata);
                futures.add(pool.submit(worker));
            }
            pool.shutdown();
            try {
                if (!pool.awaitTermination(90L, TimeUnit.MINUTES)) {
                    pool.shutdownNow();
                    if (!pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                        this.log();
                        this.log("Error - Pool did not terminate");
                    }
                }
            }
            catch (InterruptedException ie) {
                pool.shutdownNow();
                Thread.currentThread().interrupt();
            }
            if (this.isVerbose()) {
                monitorThread.interrupt();
                monitor.shutdown();
            }
            long duration = (System.currentTimeMillis() - initial) / 1000L;
            if (!this.isSilent() && !this.isQuiet()) {
                this.log("");
            }
            int exceptionsEncountered = 0;
            taskNumber = 0;
            for (Future future : futures) {
                try {
                    CheckinResponse r = (CheckinResponse)future.get();
                    int taskNum = r.getTaskNumber();
                    if (taskNum != taskNumber) {
                        throw new IllegalStateException("Task number associated with CheckinResponse \"" + taskNum + "\" out of sync with expected task number \"" + taskNumber + "\".");
                    }
                    String identifier = r.getIdentifier();
                    successfulCheckinsKeyedByIdentifier.put(identifier, r);
                    successfulCheckinsKeyedByTaskNum.put(taskNumber, r);
                    String dID = r.getDId();
                    String dDocName = r.getDDocName();
                    String dOriginalName = r.getDOriginalName();
                    long dFileSize = r.getDFileSize();
                    long seconds = r.getDuration();
                    if (this.isVerbose()) {
                        this.log(String.format("[task=%d | dID=%s | dDocName=%s | dOriginalName=%s | dFileSize=%d | duration=%d]", taskNum, dID, dDocName, dOriginalName, dFileSize, seconds));
                        continue;
                    }
                    if (this.isSilent()) continue;
                    this.log(String.format("[dID=%s | dDocName=%s | dOriginalName=%s]", dID, dDocName, dOriginalName));
                }
                catch (ExecutionException wrappedException) {
                    Throwable cause;
                    ++exceptionsEncountered;
                    allFailedCheckinsKeyedByTaskNum.put(taskNumber, wrappedException);
                    if (wrappedException.getCause() != null && (cause = wrappedException.getCause()) instanceof UploadException) {
                        UploadException ue = (UploadException)cause;
                        failedCheckinsKeyedByTaskNum.put(taskNumber, ue);
                        failedCheckinsKeyedByIdentifier.put(ue.getIdentifier(), ue);
                    }
                    this.log();
                    this.log("Error - " + wrappedException.getMessage());
                    if (!this.isVerbose()) continue;
                    this.log(wrappedException);
                }
                finally {
                    ++taskNumber;
                }
            }
            if (exceptionsEncountered > 0) {
                String msg = String.format("Exceptions encountered during bulk upload. %d of %d checkin tasks failed.", exceptionsEncountered, queueSize);
                if (throwAtCompletionOnThreadException) {
                    throw new Exception(msg);
                }
                this.log();
                this.log("Error - " + msg);
            } else if (this.isVerbose()) {
                this.log(ClientMessages.ucmclient_upload_stats(duration).toString());
            }
        }
        return results;
    }

    protected CheckinSource processLocalFileIfSpecified() throws IOException {
        LocalFileCheckinSource item = null;
        ProgramOptionsProcessor op = this.getOptionsProcessor();
        String primaryFile = ClientUtils.getStringIfPostTrimNonEmpty(op.get("primaryFile", "primary", "inputFile", "uploadFile", "file"));
        if (primaryFile != null) {
            String primaryType;
            File primary = ClientUtils.getReadableFile(primaryFile);
            String identifier = ClientUtils.getStringIfPostTrimNonEmpty(op.get("identifier", "checkinIdentifier"));
            if (identifier == null) {
                identifier = primary.getAbsolutePath();
            }
            if ((primaryType = ClientUtils.getStringIfPostTrimNonEmpty(op.get("contentType", "mimeType", "primaryContentType", "primaryMimeType", "primaryFileContentType"))) == null) {
                primaryType = "application/octet-stream";
            }
            String primaryName = ClientUtils.getStringIfPostTrimNonEmpty(op.get("originalName", "dOriginalName", "primaryName", "primaryFileName"));
            String primaryLanguage = ClientUtils.getStringIfPostTrimNonEmpty(op.get("primaryLanguage", "primaryFileLanguage", "dLanguage"));
            String primaryCharacterSet = ClientUtils.getStringIfPostTrimNonEmpty(op.get("primaryCharacterSet", "primaryFileCharacterSet", "dCharacterSet"));
            String dDocName = ClientUtils.getStringIfPostTrimNonEmpty(op.get("dDocName"));
            String dDocTitle = this.getDocTitle(op, primary.getName());
            String dSecurityGroup = this.getSecurityGroup(op);
            String dDocAccount = this.getDocAccount(op);
            String dDocType = this.getDocType(op);
            String alternateFile = ClientUtils.getStringIfPostTrimNonEmpty(op.get("alternateFile", "alternate"));
            if (alternateFile != null) {
                File alternate = ClientUtils.getReadableFile(alternateFile);
                String alternateType = ClientUtils.getStringIfPostTrimNonEmpty(op.get("alternateContentType", "alternateMimeType"));
                if (alternateType == null) {
                    alternateType = "application/octet-stream";
                }
                String alternateName = ClientUtils.getStringIfPostTrimNonEmpty(op.get("alternateName", "alternateFileName"));
                String alternateLanguage = ClientUtils.getStringIfPostTrimNonEmpty(op.get("alternateLanguage", "alternateFileLanguage"));
                String alternateCharacterSet = ClientUtils.getStringIfPostTrimNonEmpty(op.get("alternateCharacterSet", "alternateFileCharacterSet", "dCharacterSet"));
                item = new LocalFileCheckinSource(identifier, dDocName, dDocTitle, dSecurityGroup, dDocAccount, dDocType, primary, primaryType, primaryName, primaryLanguage, primaryCharacterSet, alternate, alternateType, alternateName, alternateLanguage, alternateCharacterSet);
            } else if (ClientUtils.getBooleanValue(op.get("generateAlternate", "createAlternate"), false, true)) {
                ByteArrayInputStream bis = new ByteArrayInputStream(ALTERNATE_AUTO_GENERATED_STRING.getBytes("UTF-8"));
                String alternateName = ClientUtils.getStringIfPostTrimNonEmpty(op.get("alternateName"));
                if (alternateName == null) {
                    alternateName = primary.getName() + ".nfo";
                }
                TransferFile altFile = new TransferFile(bis, alternateName, bis.available(), "text/plain");
                item = new LocalFileCheckinSource(identifier, dDocName, dDocTitle, dSecurityGroup, dDocAccount, dDocType, primary, primaryType, primaryName, primaryLanguage, primaryCharacterSet, altFile, null, "UTF-8");
            } else {
                item = new LocalFileCheckinSource(identifier, dDocName, dDocTitle, dSecurityGroup, dDocAccount, dDocType, primary, primaryType, primaryName, primaryLanguage, primaryCharacterSet);
            }
        }
        return item;
    }

    protected List<CheckinSource> processLocalDirectoryIfSpecified() throws IOException {
        ArrayList<LocalFileCheckinSource> items = null;
        ProgramOptionsProcessor op = this.getOptionsProcessor();
        String localDir = ClientUtils.getStringIfPostTrimNonEmpty(op.get("directory", "localDirectory", "uploadDirectory", "sourceDirectory"));
        if (localDir != null) {
            File[] files = ClientUtils.getDirectoryFiles(localDir);
            if (files != null && files.length > 0) {
                String dSecurityGroup = this.getSecurityGroup(op);
                String dDocAccount = this.getDocAccount(op);
                String dDocType = this.getDocType(op);
                String primaryType = ClientUtils.getStringIfPostTrimNonEmpty(op.get("contentType", "mimeType", "primaryContentType", "primaryMimeType", "primaryFileContentType"));
                if (primaryType == null) {
                    primaryType = "application/octet-stream";
                }
                items = new ArrayList(files.length);
                boolean generateAlternate = ClientUtils.getBooleanValue(op.get("generateAlternate", "createAlternate"), false, true);
                for (File primary : files) {
                    String dDocName = null;
                    String dDocTitle = primary.getName();
                    String identifier = primary.getAbsolutePath();
                    LocalFileCheckinSource item = null;
                    if (generateAlternate) {
                        ByteArrayInputStream bis = new ByteArrayInputStream(ALTERNATE_AUTO_GENERATED_STRING.getBytes("UTF-8"));
                        String alternateName = primary.getName() + ".nfo";
                        TransferFile altFile = new TransferFile(bis, alternateName, bis.available(), "text/plain");
                        item = new LocalFileCheckinSource(identifier, dDocName, dDocTitle, dSecurityGroup, dDocAccount, dDocType, primary, primaryType, null, null, null, altFile, null, "UTF-8");
                    } else {
                        item = new LocalFileCheckinSource(identifier, dDocName, dDocTitle, dSecurityGroup, dDocAccount, dDocType, primary, primaryType, null, null, null);
                    }
                    items.add(item);
                }
            } else {
                items = new ArrayList<LocalFileCheckinSource>(0);
                if (!this.isSilent()) {
                    this.log(ClientMessages.ucmclient_upload_no_files_in_local_directory_warning(localDir).toString());
                }
            }
        }
        return items;
    }

    protected String getDocTitle(ProgramOptionsProcessor op, String defaultTitle) {
        String dDocTitle = ClientUtils.getStringIfPostTrimNonEmpty(op.get("dDocTitle"));
        if (dDocTitle == null) {
            dDocTitle = defaultTitle;
            if (!this.isSilent() && !this.isQuiet()) {
                this.log(" * " + ClientMessages.ucmclient_defaulting_value_for_option("dDocTitle", dDocTitle).toString());
            }
        }
        return dDocTitle;
    }

    protected String getSecurityGroup(ProgramOptionsProcessor op) {
        String dSecurityGroup = ClientUtils.getStringIfPostTrimNonEmpty(op.get("dSecurityGroup"));
        if (dSecurityGroup == null) {
            dSecurityGroup = "Public";
            if (!this.isSilent() && !this.isQuiet()) {
                this.log(" * " + ClientMessages.ucmclient_defaulting_value_for_option("dSecurityGroup", "Public").toString());
            }
        }
        return dSecurityGroup;
    }

    protected String getDocAccount(ProgramOptionsProcessor op) {
        boolean accountRequired = ClientUtils.getTrimmedStringBooleanValue(op.get(ACCOUNT_REQUIRED));
        boolean accountTransformed = ClientUtils.getTrimmedStringBooleanValue(op.get(ACCOUNT_TRANSFORMED));
        String dDocAccount = ClientUtils.getStringIfPostTrimNonEmpty(op.get("dDocAccount"));
        if (dDocAccount == null) {
            if (accountRequired) {
                throw new IllegalStateException(ClientMessages.ucmclient_required_option_error("dDocAccount").toExceptionString());
            }
            dDocAccount = "";
            if (this.isVerbose()) {
                this.log(" * " + ClientMessages.ucmclient_defaulting_value_for_option("dDocAccount", "").toString());
            }
        } else if (accountTransformed) {
            String transformed = ClientUtils.transformAccount(dDocAccount);
            if (this.isVerbose()) {
                this.log(" * " + ClientMessages.ucmclient_option_transformed("dDocAccount", dDocAccount, transformed).toString());
            }
            dDocAccount = transformed;
        }
        return dDocAccount;
    }

    protected String getDocType(ProgramOptionsProcessor op) {
        String dDocType = ClientUtils.getStringIfPostTrimNonEmpty(op.get("dDocType"));
        if (dDocType == null) {
            dDocType = "Document";
            if (!this.isSilent() && !this.isQuiet()) {
                this.log(" * " + ClientMessages.ucmclient_defaulting_value_for_option("dDocType", "Document").toString());
            }
        }
        return dDocType;
    }

    protected void performCheckoutIfRequested(ProgramOptionsProcessor op, String dDocName) throws Exception {
        boolean performCheckout = ClientUtils.getBooleanValue(op.get("checkout"), false, true);
        if (dDocName != null && performCheckout) {
            boolean ignoreCheckoutErrorNeg22 = ClientUtils.getBooleanValue(op.get("ignoreCheckoutErrorNeg22"), true, true);
            this.checkout(dDocName, ignoreCheckoutErrorNeg22);
        }
    }

    protected void checkout(String dDocName, boolean ignoreCheckoutErrorNeg22) throws Exception {
        ServiceResponse response;
        DataBinder request = this.createServiceRequest("CHECKOUT_BY_NAME");
        this.addRequestProperty(request, "dDocName", dDocName);
        if (this.isVerbose()) {
            this.log();
            this.log(ClientMessages.ucmclient_content_server_request_payload().toString());
            this.log(request);
        }
        long initial = System.currentTimeMillis();
        if (!this.isSilent() && !this.isQuiet()) {
            this.log(ClientMessages.ucmclient_performing_checkout().toString());
        }
        if ((response = this.sendRequest(request)) == null) {
            throw new IllegalStateException(ClientMessages.ucmclient_checkout_response_null_error().toExceptionString());
        }
        if (!response.getResponseType().equals((Object)ServiceResponse.ResponseType.BINDER)) {
            throw new IllegalStateException(ClientMessages.ucmclient_checkout_response_not_a_binder_error().toExceptionString());
        }
        DataBinder responseBinder = null;
        try {
            responseBinder = response.getResponseAsBinder();
        }
        catch (ServiceException se) {
            if (se.getStatusCode() == -22 && ignoreCheckoutErrorNeg22) {
                if (!this.isSilent() && !this.isQuiet()) {
                    this.log(ClientMessages.ucmclient_checkout_ignore_status22().toString());
                }
            }
            throw se;
        }
        long duration = (System.currentTimeMillis() - initial) / 1000L;
        if (this.isVerbose()) {
            this.log(ClientMessages.ucmclient_checkout_stats(duration).toString());
            this.log();
            this.log(ClientMessages.ucmclient_content_server_response_payload().toString());
            this.log(responseBinder);
        }
        if (!this.isSilent()) {
            this.log(ClientMessages.ucmclient_checkout_successful().toString());
        }
    }

    public void setCheckinItems(List<CheckinSource> checkinItems) {
        this.m_checkinItems = checkinItems;
    }

    public List<CheckinSource> getCheckinItems() {
        return this.m_checkinItems;
    }

    @Override
    protected String getToolClassAndRevision() {
        String revision = ClientUtils.getRevision(UploadTool.idcVersionInfo(null));
        String parentRevision = ClientUtils.getRevision(AbstractTool.idcVersionInfo(null));
        return "UploadTool" + (revision != null && revision.length() > 0 ? " [r" + revision + "]/[p" + parentRevision + "]" : "");
    }

    @Override
    protected String getUsage() {
        return ClientMessages.ucmclient_upload_usage().toString();
    }

    @Override
    protected String getToolHeader() {
        return TOOL;
    }

    @Override
    protected String getToolRestrictionsOptionsResource() {
        return TOOL_RESTRICTIONS_OPTIONS_RESOURCE;
    }

    @Override
    protected String getToolDefaultOptionsResource() {
        return TOOL_DEFAULT_OPTIONS_RESOURCE;
    }

    public static Object idcVersionInfo(Object arg) {
        return "releaseInfo=dev,releaseRevision=$Rev: 122355 $";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UploadResults {
        private Map<Integer, CheckinResponse> m_successfulCheckinsKeyedByTaskNum;
        private Map<String, CheckinResponse> m_successfulCheckinsKeyedByIdentifier;
        private Map<Integer, Exception> m_allFailedCheckinsKeyedByTaskNum;
        private Map<Integer, UploadException> m_failedCheckinsKeyedByTaskNum;
        private Map<String, UploadException> m_failedCheckinsKeyedByIdentifier;

        public UploadResults(Map<Integer, CheckinResponse> successfulCheckinsKeyedByTaskNum, Map<String, CheckinResponse> successfulCheckinsKeyedByIdentifier, Map<Integer, Exception> allFailedCheckinsKeyedByTaskNum, Map<Integer, UploadException> failedCheckinsKeyedByTaskNum, Map<String, UploadException> failedCheckinsKeyedByIdentifier) {
            this.m_successfulCheckinsKeyedByTaskNum = successfulCheckinsKeyedByTaskNum;
            this.m_successfulCheckinsKeyedByIdentifier = successfulCheckinsKeyedByIdentifier;
            this.m_allFailedCheckinsKeyedByTaskNum = allFailedCheckinsKeyedByTaskNum;
            this.m_failedCheckinsKeyedByTaskNum = failedCheckinsKeyedByTaskNum;
            this.m_failedCheckinsKeyedByIdentifier = failedCheckinsKeyedByIdentifier;
        }

        public Map<Integer, CheckinResponse> getSuccessfulCheckinsKeyedByTaskNum() {
            return this.m_successfulCheckinsKeyedByTaskNum;
        }

        public Map<String, CheckinResponse> getSuccessfulCheckinsKeyedByIdentifier() {
            return this.m_successfulCheckinsKeyedByIdentifier;
        }

        public Map<Integer, Exception> getAllFailedCheckinsKeyedByTaskNum() {
            return this.m_allFailedCheckinsKeyedByTaskNum;
        }

        public Map<Integer, UploadException> getFailedCheckinsKeyedByTaskNum() {
            return this.m_failedCheckinsKeyedByTaskNum;
        }

        public Map<String, UploadException> getFailedCheckinsKeyedByIdentifier() {
            return this.m_failedCheckinsKeyedByIdentifier;
        }
    }
}

