/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucm.client.auth;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import oracle.ucm.client.utils.ClientUtils;
import oracle.ucm.client.utils.LogUtils;

public class AuthProxyClient {
    private static final String COOKIE_REQUEST_VERB = "GET_COOKIES URL=";
    private static final String COOKIE_RESPONSE_VERB = "GET_COOKIES RESPONSE=";
    private static final String EOF_TOKEN = "<EOF>";
    private LogUtils m_logger;

    public AuthProxyClient(LogUtils ridcLogger) {
        this.m_logger = ridcLogger;
    }

    public String getCookies(String url, String authProxy, boolean authProxySSLEnabled, String authProxySSLTrustStore, String authProxySSLTrustStorePassword, boolean authProxySSLClientAuth, String authProxySSLKeyStore, String authProxySSLKeyStorePassword, String authProxySSLKeyStoreClientKeyAlias, String authProxySSLKeyStoreClientKeyPassword) {
        String cookies = null;
        Socket s = null;
        OutputStream os = null;
        InputStream is = null;
        try {
            s = this.getSocket(authProxy, authProxySSLEnabled, authProxySSLTrustStore, authProxySSLTrustStorePassword, authProxySSLClientAuth, authProxySSLKeyStore, authProxySSLKeyStorePassword, authProxySSLKeyStoreClientKeyAlias, authProxySSLKeyStoreClientKeyPassword);
            os = s.getOutputStream();
            is = s.getInputStream();
            this.writeGetCookiesRequest(url, os);
            String response = this.readGetCookiesResponse(is);
            this.log(response);
            cookies = this.extractCookiesFromResponse(response);
        }
        catch (IOException e) {
            try {
                this.logException(e);
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                ClientUtils.streamClose(os);
                ClientUtils.streamClose(is);
                this.socketClose(s);
                throw throwable;
            }
        }
        ClientUtils.streamClose(os);
        ClientUtils.streamClose(is);
        this.socketClose(s);
        return cookies;
    }

    private void socketClose(Socket socket) {
        try {
            if (socket != null) {
                socket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String extractCookiesFromResponse(String response) {
        String cookies = null;
        if (response != null && response.length() > 0 && response.startsWith(COOKIE_RESPONSE_VERB) && response.indexOf(EOF_TOKEN) != -1) {
            cookies = response.substring(COOKIE_RESPONSE_VERB.length(), response.indexOf(EOF_TOKEN));
        }
        return cookies;
    }

    private String readGetCookiesResponse(InputStream is) throws IOException {
        String charset = "UTF-8";
        int count = 0;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);
        byte[] buffer = new byte[8192];
        while ((count = is.read(buffer)) != -1) {
            baos.write(buffer, 0, count);
        }
        String response = baos.toString(charset);
        return response;
    }

    private void writeGetCookiesRequest(String url, OutputStream os) throws IOException {
        String charset = "UTF-8";
        byte[] requestBytes = (COOKIE_REQUEST_VERB + url + EOF_TOKEN).getBytes(charset);
        os.write(requestBytes);
        os.flush();
    }

    private Socket getSocket(String authProxy, boolean authProxySSLEnabled, String authProxySSLTrustStore, String authProxySSLTrustStorePassword, boolean authProxySSLClientAuth, String authProxySSLKeyStore, String authProxySSLKeyStorePassword, String authProxySSLKeyStoreClientKeyAlias, String authProxySSLKeyStoreClientKeyPassword) throws IOException {
        authProxy = authProxy.trim();
        int port = 16443;
        String host = authProxy;
        int colonIndex = authProxy.indexOf(58);
        if (colonIndex >= 1 && colonIndex + 1 < authProxy.length()) {
            host = authProxy.substring(0, colonIndex);
            port = ClientUtils.getIntValue(authProxy.substring(colonIndex + 1), port);
        } else if (colonIndex != -1) {
            host = "127.0.0.1";
        }
        Socket socket = null;
        if (authProxySSLEnabled) {
            SSLSocketFactory factory = this.getSSLSocketFactory(authProxySSLTrustStore, authProxySSLTrustStorePassword, authProxySSLKeyStore, authProxySSLKeyStorePassword, authProxySSLClientAuth, authProxySSLKeyStoreClientKeyAlias, authProxySSLKeyStoreClientKeyPassword);
            socket = factory.createSocket(host, port);
            ((SSLSocket)socket).setEnabledProtocols(new String[]{"TLSv1"});
            ((SSLSocket)socket).setUseClientMode(true);
            ((SSLSocket)socket).startHandshake();
            this.logSSLSocketInfo((SSLSocket)socket);
        } else {
            socket = new Socket(host, port);
        }
        socket.setKeepAlive(false);
        socket.setSoTimeout(120000);
        return socket;
    }

    private SSLSocketFactory getSSLSocketFactory(String authProxySSLTrustStore, String authProxySSLTrustStorePassword, String authProxySSLKeyStore, String authProxySSLKeyStorePassword, boolean authProxySSLClientAuth, final String authProxySSLKeyStoreClientKeyAlias, String authProxySSLKeyStoreClientKeyPassword) {
        SSLSocketFactory factory = null;
        TrustManager[] trustManagers = this.getTrustManagers(authProxySSLTrustStore, authProxySSLTrustStorePassword);
        KeyManager[] keyManagers = this.getKeyManagers(authProxySSLKeyStore, authProxySSLKeyStorePassword);
        if (authProxySSLClientAuth && authProxySSLKeyStoreClientKeyAlias != null) {
            final X509KeyManager origKm = (X509KeyManager)keyManagers[0];
            X509KeyManager km = new X509KeyManager(){

                public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
                    return authProxySSLKeyStoreClientKeyAlias;
                }

                public String[] getClientAliases(String keyType, Principal[] issuers) {
                    String[] aliases = origKm.getClientAliases(keyType, issuers);
                    return aliases;
                }

                public String[] getServerAliases(String keyType, Principal[] issuers) {
                    String[] aliases = origKm.getServerAliases(keyType, issuers);
                    return aliases;
                }

                public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
                    String alias = origKm.chooseServerAlias(keyType, issuers, socket);
                    return alias;
                }

                public X509Certificate[] getCertificateChain(String alias) {
                    X509Certificate[] chain = origKm.getCertificateChain(alias);
                    return chain;
                }

                public PrivateKey getPrivateKey(String alias) {
                    PrivateKey key = origKm.getPrivateKey(alias);
                    return key;
                }
            };
            keyManagers = new KeyManager[]{km};
        }
        try {
            SSLContext sslContext = SSLContext.getInstance("TLSv1");
            sslContext.init(keyManagers, trustManagers, null);
            factory = sslContext.getSocketFactory();
        }
        catch (GeneralSecurityException e) {
            this.logException(e);
            throw new IllegalStateException(e);
        }
        return factory;
    }

    private TrustManager[] getTrustManagers(String authProxySSLTrustStore, String authProxySSLTrustStorePassword) {
        TrustManager[] trustManagers = null;
        if (authProxySSLTrustStore != null && authProxySSLTrustStorePassword != null) {
            try {
                KeyStore trustStore = this.loadJKSKeyStore(authProxySSLTrustStore, authProxySSLTrustStorePassword);
                if (trustStore != null) {
                    String algorithm = TrustManagerFactory.getDefaultAlgorithm();
                    TrustManagerFactory factory = TrustManagerFactory.getInstance(algorithm);
                    factory.init(trustStore);
                    trustManagers = factory.getTrustManagers();
                }
            }
            catch (IOException e) {
                this.logException(e);
                throw new IllegalStateException(e);
            }
            catch (GeneralSecurityException e) {
                this.logException(e);
                throw new IllegalStateException(e);
            }
        }
        return trustManagers;
    }

    private KeyManager[] getKeyManagers(String authProxySSLKeyStore, String authProxySSLKeyStorePassword) {
        KeyManager[] keyManagers = null;
        if (authProxySSLKeyStore != null && authProxySSLKeyStorePassword != null) {
            try {
                KeyStore keyStore = this.loadJKSKeyStore(authProxySSLKeyStore, authProxySSLKeyStorePassword);
                if (keyStore != null) {
                    String algorithm = KeyManagerFactory.getDefaultAlgorithm();
                    KeyManagerFactory factory = KeyManagerFactory.getInstance(algorithm);
                    factory.init(keyStore, authProxySSLKeyStorePassword.toCharArray());
                    keyManagers = factory.getKeyManagers();
                }
            }
            catch (IOException e) {
                this.logException(e);
                throw new IllegalStateException(e);
            }
            catch (GeneralSecurityException e) {
                this.logException(e);
                throw new IllegalStateException(e);
            }
        }
        return keyManagers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore loadJKSKeyStore(String path, String password) throws GeneralSecurityException, IOException {
        KeyStore ks = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(path);
            KeyStore store = KeyStore.getInstance("JKS");
            store.load(fis, password.toCharArray());
            ks = store;
        }
        catch (Throwable throwable) {
            ClientUtils.streamClose(fis);
            throw throwable;
        }
        ClientUtils.streamClose(fis);
        return ks;
    }

    private void logSSLSocketInfo(SSLSocket s) {
        this.log("Socket class: " + s.getClass());
        this.log("   Remote address = " + s.getInetAddress().toString());
        this.log("   Remote port = " + s.getPort());
        this.log("   Local socket address = " + s.getLocalSocketAddress().toString());
        this.log("   Local address = " + s.getLocalAddress().toString());
        this.log("   Local port = " + s.getLocalPort());
        SSLSession ss = s.getSession();
        this.log("   Cipher suite = " + ss.getCipherSuite());
        this.log("   Protocol = " + ss.getProtocol());
    }

    protected LogUtils getLogger() {
        return this.m_logger;
    }

    protected void log(String message) {
        LogUtils logger = this.getLogger();
        if (logger != null) {
            logger.log("[AuthProxyClient] " + message);
        }
    }

    protected void logException(Exception e) {
        LogUtils logger = this.getLogger();
        if (logger != null) {
            logger.logException(e);
        }
    }

    public static Object idcVersionInfo(Object arg) {
        return "releaseInfo=dev,releaseRevision=$Rev: 117128 $";
    }
}

