/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucm.client.auth;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentSkipListSet;
import oracle.ucm.client.utils.LogUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLConnectionProxySelector
extends ProxySelector {
    private final ProxySelector m_defaultProxySelector;
    private final String m_nonProxyHostsPattern;
    private final boolean m_nonProxyHostsInUse;
    private final ConcurrentSkipListSet<String> m_proxyExcludedHosts = new ConcurrentSkipListSet();
    private final ConcurrentSkipListSet<String> m_proxyApplicableHosts = new ConcurrentSkipListSet();
    private final ConcurrentSkipListSet<String> m_hostsWithInitialConnectFailure = new ConcurrentSkipListSet();
    private final ConcurrentSkipListSet<String> m_hostsWithMultipleConnectFailure = new ConcurrentSkipListSet();
    private final Proxy m_httpProxy;
    private LogUtils m_logger;

    public URLConnectionProxySelector(ProxySelector proxySelector, String proxyHost, int proxyPort, String nonProxyHosts, LogUtils ridcLogger) {
        this.m_defaultProxySelector = proxySelector;
        this.m_logger = ridcLogger;
        this.m_httpProxy = new Proxy(Proxy.Type.HTTP, InetSocketAddress.createUnresolved(proxyHost, proxyPort));
        this.log(String.format("proxy: %s:%d", proxyHost, proxyPort));
        boolean bl = this.m_nonProxyHostsInUse = nonProxyHosts != null && nonProxyHosts.length() > 0;
        if (this.m_nonProxyHostsInUse) {
            String nonProxyHostsLower = nonProxyHosts.toLowerCase();
            StringBuilder sb = new StringBuilder();
            block4: for (int i = 0; i < nonProxyHostsLower.length(); ++i) {
                char ch = nonProxyHostsLower.charAt(i);
                switch (ch) {
                    case '*': {
                        sb.append(".*");
                        continue block4;
                    }
                    case '.': {
                        sb.append("\\.");
                        continue block4;
                    }
                    default: {
                        sb.append(ch);
                    }
                }
            }
            this.m_nonProxyHostsPattern = sb.toString();
            this.log(String.format("non-proxy hosts regex pattern: %s", this.m_nonProxyHostsPattern));
        } else {
            this.m_nonProxyHostsPattern = null;
        }
    }

    @Override
    public List<Proxy> select(URI uri) {
        boolean isHTTP;
        if (uri == null) {
            throw new IllegalArgumentException("URI can't be null.");
        }
        String protocol = uri.getScheme();
        String host = uri.getHost();
        if (host == null) {
            host = this.getHostFromAuthority(uri);
        }
        if (protocol == null || host == null) {
            throw new IllegalArgumentException("protocol = " + protocol + " host = " + host);
        }
        String hostLower = host.toLowerCase();
        boolean bl = isHTTP = "http".equalsIgnoreCase(protocol) || "https".equalsIgnoreCase(protocol);
        if (isHTTP && !this.m_hostsWithInitialConnectFailure.contains(hostLower)) {
            Proxy proxy = null;
            if (!this.m_nonProxyHostsInUse) {
                this.log(String.format("static - proxy for host: %s", hostLower));
                proxy = this.m_httpProxy;
            } else if (this.m_proxyApplicableHosts.contains(hostLower)) {
                this.log(String.format("cached - proxy for host: %s", hostLower));
                proxy = this.m_httpProxy;
            } else if (this.m_proxyExcludedHosts.contains(hostLower)) {
                this.log(String.format("cached - no-proxy for host: %s", hostLower));
                proxy = Proxy.NO_PROXY;
            } else {
                boolean excluded = hostLower.matches(this.m_nonProxyHostsPattern);
                if (excluded) {
                    this.log(String.format("no-proxy for host: %s", hostLower));
                    this.m_proxyExcludedHosts.add(hostLower);
                    proxy = Proxy.NO_PROXY;
                } else {
                    this.log(String.format("proxy for host: %s", hostLower));
                    this.m_proxyApplicableHosts.add(hostLower);
                    proxy = this.m_httpProxy;
                }
            }
            return Collections.singletonList(proxy);
        }
        if (this.m_defaultProxySelector != null && (!isHTTP || isHTTP && !this.m_hostsWithMultipleConnectFailure.contains(hostLower))) {
            if (isHTTP) {
                this.log(String.format("reverted to default proxy selector for host: %s", hostLower));
            }
            return this.m_defaultProxySelector.select(uri);
        }
        if (isHTTP) {
            this.log(String.format("reverted to no-proxy for host: %s", hostLower));
        }
        return Collections.singletonList(Proxy.NO_PROXY);
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        boolean isHTTP;
        if (uri == null || sa == null || ioe == null) {
            throw new IllegalArgumentException("Arguments can't be null.");
        }
        String protocol = uri.getScheme();
        String host = uri.getHost();
        if (host == null) {
            host = this.getHostFromAuthority(uri);
        }
        String hostLower = host.toLowerCase();
        boolean bl = isHTTP = "http".equalsIgnoreCase(protocol) || "https".equalsIgnoreCase(protocol);
        if (isHTTP) {
            this.log(String.format("connection failure to host %s leveraging proxy %s : %s", hostLower, sa.toString(), ioe.getMessage()));
            this.logException(ioe);
            if (!this.m_hostsWithInitialConnectFailure.contains(hostLower)) {
                this.m_hostsWithInitialConnectFailure.add(hostLower);
            } else if (!this.m_hostsWithMultipleConnectFailure.contains(hostLower)) {
                this.m_hostsWithMultipleConnectFailure.add(hostLower);
            }
        }
    }

    private String getHostFromAuthority(URI uri) {
        String host = null;
        String auth = uri.getAuthority();
        if (auth != null) {
            int i = auth.indexOf(64);
            if (i >= 0) {
                auth = auth.substring(i + 1);
            }
            if ((i = auth.lastIndexOf(58)) >= 0) {
                auth = auth.substring(0, i);
            }
            host = auth;
        }
        return host;
    }

    protected LogUtils getLogger() {
        return this.m_logger;
    }

    protected void log(String message) {
        LogUtils logger = this.getLogger();
        if (logger != null) {
            logger.log("[URLConnectionProxySelector] " + message);
        }
    }

    protected void logException(Exception e) {
        LogUtils logger = this.getLogger();
        if (logger != null) {
            logger.logException(e);
        }
    }

    public static Object idcVersionInfo(Object arg) {
        return "releaseInfo=dev,releaseRevision=$Rev: 114141 $";
    }
}

