/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucm.client.bulk;

import java.util.Map;
import java.util.concurrent.Callable;
import oracle.stellent.ridc.IdcContext;
import oracle.stellent.ridc.model.DataBinder;
import oracle.stellent.ridc.model.TransferFile;
import oracle.stellent.ridc.protocol.ServiceResponse;
import oracle.ucm.client.AbstractTool;
import oracle.ucm.client.bulk.UploadException;
import oracle.ucm.client.i18n.ClientMessages;
import oracle.ucm.client.model.content.CheckinSource;
import oracle.ucm.client.model.response.CheckinResponse;
import oracle.ucm.client.utils.LogUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadThread
implements Callable<CheckinResponse> {
    private int m_taskNumber;
    private AbstractTool m_tool;
    private CheckinSource m_checkinSource;
    private Map<String, String> m_customMetadata;

    public UploadThread(int taskNumber, AbstractTool tool, CheckinSource checkinSource, Map<String, String> metadata) {
        this.m_taskNumber = taskNumber;
        this.m_tool = tool;
        this.m_checkinSource = checkinSource;
        this.m_customMetadata = metadata;
    }

    @Override
    public CheckinResponse call() throws Exception {
        CheckinResponse checkinResponse = null;
        IdcContext userContext = new IdcContext(this.m_tool.getIdcContext().getCredentials());
        CheckinSource source = this.getCheckinSource();
        String identifier = source.getIdentifier();
        try {
            ServiceResponse response;
            TransferFile alternate;
            DataBinder request = this.m_tool.createServiceRequest("CHECKIN_UNIVERSAL");
            String dDocName = source.getDDocName();
            if (dDocName != null) {
                this.m_tool.addRequestProperty(request, "dDocName", dDocName);
            }
            this.m_tool.addRequestProperty(request, "dSecurityGroup", source.getDSecurityGroup());
            this.m_tool.addRequestProperty(request, "dDocAccount", source.getDDocAccount());
            this.m_tool.addRequestProperty(request, "dDocType", source.getDDocType());
            this.m_tool.addRequestProperty(request, "dDocTitle", source.getDDocTitle());
            TransferFile primary = source.getPrimaryFile();
            request.addFile("primaryFile", primary);
            if (source.getPrimaryFileCharacterSet() != null) {
                this.m_tool.addRequestProperty(request, "primaryFile:dCharacterSet", source.getPrimaryFileCharacterSet());
            }
            if (source.getPrimaryFileLanguage() != null) {
                this.m_tool.addRequestProperty(request, "primaryFile:dLanguage", source.getPrimaryFileLanguage());
            }
            if ((alternate = source.getAlternateFile()) != null) {
                request.addFile("alternateFile", alternate);
                if (source.getAlternateFileCharacterSet() != null) {
                    this.m_tool.addRequestProperty(request, "alternateFile:dCharacterSet", source.getAlternateFileCharacterSet());
                }
                if (source.getAlternateFileLanguage() != null) {
                    this.m_tool.addRequestProperty(request, "alternateFile:dLanguage", source.getAlternateFileLanguage());
                }
            }
            for (Map.Entry<String, String> entry : this.m_customMetadata.entrySet()) {
                this.m_tool.addRequestProperty(request, entry.getKey(), entry.getValue());
            }
            if (this.isVerbose()) {
                this.log();
                this.log(ClientMessages.ucmclient_content_server_request_payload().toString());
                this.log(request);
            }
            long initial = System.currentTimeMillis();
            if (!this.isSilent() && !this.isQuiet()) {
                this.log(ClientMessages.ucmclient_performing_upload().toString());
            }
            if ((response = this.m_tool.getIdcClient().sendRequest(userContext, request)) == null) {
                throw new IllegalStateException(ClientMessages.ucmclient_upload_response_null_error().toExceptionString());
            }
            if (!response.getResponseType().equals((Object)ServiceResponse.ResponseType.BINDER)) {
                throw new IllegalStateException(ClientMessages.ucmclient_upload_response_not_a_binder_error().toExceptionString());
            }
            DataBinder responseBinder = response.getResponseAsBinder();
            String dID = responseBinder.getLocal("dID");
            dDocName = responseBinder.getLocal("dDocName");
            String dDocTitle = responseBinder.getLocal("dDocTitle");
            String dOriginalName = responseBinder.getLocal("dOriginalName");
            long dFileSize = new Long(responseBinder.getLocal("dFileSize"));
            long duration = (System.currentTimeMillis() - initial) / 1000L;
            checkinResponse = new CheckinResponse(identifier, this.m_taskNumber, dID, dDocName, dDocTitle, dOriginalName, dFileSize, duration);
            if (this.isVerbose()) {
                this.log(ClientMessages.ucmclient_upload_stats(duration).toString());
                this.log();
                this.log(ClientMessages.ucmclient_content_server_response_payload().toString());
                this.log(responseBinder);
            }
            if (!this.isSilent() && !this.isQuiet()) {
                this.log(ClientMessages.ucmclient_upload_successful().toString() + " [dID=" + dID + " | dDocName=" + dDocName + "]");
            }
        }
        catch (Exception e) {
            this.log(String.format("ERROR - \"%s\" ; Error occurred uploading primaryFile \"%s\" with dDocTitle \"%s\" and checkin identifier \"%s\".", e.getMessage(), source.getPrimaryFile().getFileName(), source.getDDocTitle(), identifier));
            if (this.m_tool.isVerbose()) {
                this.log(e);
            }
            throw new UploadException(String.format("ERROR - \"%s\" ; Error occurred for task %d uploading primaryFile \"%s\" with dDocTitle \"%s\" and checkin identifier \"%s\".", e.getMessage(), this.m_taskNumber, source.getPrimaryFile().getFileName(), source.getDDocTitle(), identifier), (Throwable)e, identifier, this.m_taskNumber);
        }
        finally {
            source.closePrimaryFile();
            source.closeAlternateFile();
            this.logout(userContext);
        }
        return checkinResponse;
    }

    protected boolean isVerbose() {
        return this.m_tool.isVerbose();
    }

    protected boolean isSilent() {
        return this.m_tool.isSilent();
    }

    protected boolean isQuiet() {
        return this.m_tool.isQuiet();
    }

    protected void logout(IdcContext userContext) {
        this.m_tool.logout(userContext);
    }

    protected LogUtils getLogger() {
        return this.m_tool.getLogger();
    }

    protected void log() {
        this.getLogger().log();
    }

    protected void log(String message) {
        this.getLogger().log(Thread.currentThread().getName() + " task:" + this.m_taskNumber + " - " + message);
    }

    protected void log(Exception e) {
        this.getLogger().log(Thread.currentThread().getName() + " task:" + this.m_taskNumber + " - Exception: " + e.getMessage());
        this.getLogger().logException(e);
    }

    protected void log(DataBinder db) {
        this.getLogger().log(Thread.currentThread().getName() + " task:" + this.m_taskNumber + " - Binder: ");
        String indent = this.getLogger().getDefaultIndent();
        this.getLogger().logDataBinder(db, indent);
    }

    protected CheckinSource getCheckinSource() {
        return this.m_checkinSource;
    }

    public static Object idcVersionInfo(Object arg) {
        return "releaseInfo=dev,releaseRevision=$Rev: 122355 $";
    }
}

