/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucm.client.i18n;

import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class LocalizedMessageWrapper {
    private String bundle = null;
    private String key = null;
    private Object[] parameters = null;

    public LocalizedMessageWrapper(String bundle, String key, Object[] parameters) {
        this.setBundle(bundle);
        this.setKey(key);
        this.setParameters(parameters);
    }

    public LocalizedMessageWrapper(String bundle, String key) {
        this.setBundle(bundle);
        this.setKey(key);
    }

    public String getBundle() {
        return this.bundle;
    }

    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public void setParameters(Object[] parameters) {
        this.parameters = parameters;
    }

    public String toString() {
        return LocalizedMessageWrapper.getString(this.bundle, this.key, this.parameters);
    }

    public String toExceptionString() {
        return this.getKey() + ": " + LocalizedMessageWrapper.getString(this.bundle, this.key, this.parameters);
    }

    public static String getString(String bundleName, String key) {
        try {
            return LocalizedMessageWrapper.getResourceBundle(bundleName).getString(key);
        }
        catch (MissingResourceException exception) {
            return "!" + key + "! : Not Found.";
        }
    }

    public static String getString(String bundleName, String key, Object ... parameters) {
        String message = LocalizedMessageWrapper.getString(bundleName, key);
        StringBuffer buffer = new StringBuffer();
        new MessageFormat(message).format(parameters, buffer, (FieldPosition)null);
        return buffer.toString();
    }

    public static String getString(Locale locale, String bundleName, String key, Object ... parameters) {
        StringBuffer buffer = new StringBuffer();
        String message = LocalizedMessageWrapper.getResourceBundle(bundleName, locale).getString(key);
        new MessageFormat(message, locale).format(parameters, buffer, (FieldPosition)null);
        return buffer.toString();
    }

    public static ResourceBundle getResourceBundle(String bundleName) {
        return ResourceBundle.getBundle(bundleName);
    }

    public static ResourceBundle getResourceBundle(String bundleName, Locale locale) {
        return ResourceBundle.getBundle(bundleName, locale);
    }

    public static Object idcVersionInfo(Object arg) {
        return "releaseInfo=dev,releaseRevision=$Rev: 101415 $";
    }
}

