/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucm.client.model.content.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import oracle.stellent.ridc.model.TransferFile;
import oracle.ucm.client.model.content.CheckinSource;
import oracle.ucm.client.utils.ClientUtils;

public class LocalFileCheckinSource
implements CheckinSource {
    private String m_identifier = null;
    private String m_dDocName = null;
    private String m_dDocTitle;
    private String m_dSecurityGroup;
    private String m_dDocAccount;
    private String m_dDocType;
    private TransferFile m_primaryFile = null;
    private String m_primaryFileLanguage = null;
    private String m_primaryFileCharacterSet = null;
    private TransferFile m_alternateFile = null;
    private String m_alternateFileLanguage = null;
    private String m_alternateFileCharacterSet = null;

    private LocalFileCheckinSource(String identifier, String dDocName, String dDocTitle, String dSecurityGroup, String dDocAccount, String dDocType) {
        this.m_identifier = identifier;
        this.m_dDocName = dDocName;
        this.m_dDocTitle = dDocTitle;
        this.m_dSecurityGroup = dSecurityGroup;
        this.m_dDocAccount = dDocAccount;
        this.m_dDocType = dDocType;
    }

    public LocalFileCheckinSource(String identifier, String dDocName, String dDocTitle, String dSecurityGroup, String dDocAccount, String dDocType, File primary, String primaryType, String primaryName, String primaryLanguage, String primaryCharacterSet) throws IOException {
        this(identifier, dDocName, dDocTitle, dSecurityGroup, dDocAccount, dDocType);
        TransferFile primaryFile = new TransferFile(primary, primaryType);
        if (primaryName != null) {
            primaryFile.setFileName(primaryName);
        }
        this.m_primaryFile = primaryFile;
        this.m_primaryFileLanguage = primaryLanguage;
        this.m_primaryFileCharacterSet = primaryCharacterSet;
    }

    public LocalFileCheckinSource(String identifier, String dDocName, String dDocTitle, String dSecurityGroup, String dDocAccount, String dDocType, File primary, String primaryType, String primaryName, String primaryLanguage, String primaryCharacterSet, File alternate, String alternateType, String alternateName, String alternateLanguage, String alternateCharacterSet) throws IOException {
        this(identifier, dDocName, dDocTitle, dSecurityGroup, dDocAccount, dDocType, primary, primaryType, primaryName, primaryLanguage, primaryCharacterSet);
        TransferFile alternateFile = new TransferFile(alternate, alternateType);
        if (alternateName != null) {
            alternateFile.setFileName(alternateName);
        }
        this.m_alternateFile = alternateFile;
        this.m_alternateFileLanguage = alternateLanguage;
        this.m_alternateFileCharacterSet = alternateCharacterSet;
    }

    public LocalFileCheckinSource(String identifier, String dDocName, String dDocTitle, String dSecurityGroup, String dDocAccount, String dDocType, File primary, String primaryType, String primaryName, String primaryLanguage, String primaryCharacterSet, TransferFile alternateFile, String alternateLanguage, String alternateCharacterSet) throws IOException {
        this(identifier, dDocName, dDocTitle, dSecurityGroup, dDocAccount, dDocType, primary, primaryType, primaryName, primaryLanguage, primaryCharacterSet);
        this.m_alternateFile = alternateFile;
        this.m_alternateFileLanguage = alternateLanguage;
        this.m_alternateFileCharacterSet = alternateCharacterSet;
    }

    public String getIdentifier() {
        return this.m_identifier;
    }

    public String getDDocName() {
        return this.m_dDocName;
    }

    public String getDDocTitle() {
        return this.m_dDocTitle;
    }

    public String getDSecurityGroup() {
        return this.m_dSecurityGroup;
    }

    public String getDDocAccount() {
        return this.m_dDocAccount;
    }

    public String getDDocType() {
        return this.m_dDocType;
    }

    public TransferFile getPrimaryFile() {
        return this.m_primaryFile;
    }

    public TransferFile getAlternateFile() {
        return this.m_alternateFile;
    }

    public void closePrimaryFile() {
        try {
            InputStream is;
            InputStream inputStream = is = this.m_primaryFile != null ? this.m_primaryFile.getInputStream() : null;
            if (is != null) {
                ClientUtils.streamDrain(is);
                ClientUtils.streamClose(is);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void closeAlternateFile() {
        try {
            InputStream is;
            InputStream inputStream = is = this.m_alternateFile != null ? this.m_alternateFile.getInputStream() : null;
            if (is != null) {
                ClientUtils.streamDrain(is);
                ClientUtils.streamClose(is);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getPrimaryFileLanguage() {
        return this.m_primaryFileLanguage;
    }

    public String getPrimaryFileCharacterSet() {
        return this.m_primaryFileCharacterSet;
    }

    public String getAlternateFileLanguage() {
        return this.m_alternateFileLanguage;
    }

    public String getAlternateFileCharacterSet() {
        return this.m_alternateFileCharacterSet;
    }

    public static Object idcVersionInfo(Object arg) {
        return "releaseInfo=dev,releaseRevision=$Rev: 122351 $";
    }
}

