/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucm.client.odi;

import java.util.ResourceBundle;
import oracle.odi.sdk.opentools.IOpenToolParameter;

public class ContentParam
implements IOpenToolParameter {
    private String mCode;
    private String mName;
    private String mHelp;
    private Object mValue;
    private boolean mMandatory;
    private boolean mTrimValue;
    private boolean mSubmitIfEmpty;

    public ContentParam(String pCode, ResourceBundle pBundle) {
        String pName = pBundle.getString("CONTENT_PARAM_" + pCode);
        String pHelp = pBundle.getString("CONTENT_PARAM_" + pCode + "_Desc");
        String pMandatory = pBundle.getString("CONTENT_PARAM_" + pCode + "_Mandatory");
        String pTrimValue = pBundle.getString("CONTENT_PARAM_" + pCode + "_TrimValue");
        String pSubmitIfEmpty = pBundle.getString("CONTENT_PARAM_" + pCode + "_SubmitIfEmpty");
        this.mCode = pCode;
        this.mName = pName;
        this.mHelp = pHelp;
        this.mMandatory = pMandatory != null && "true".equalsIgnoreCase(pMandatory.trim());
        this.mTrimValue = pTrimValue != null && "true".equalsIgnoreCase(pTrimValue.trim());
        this.mSubmitIfEmpty = pSubmitIfEmpty != null && "true".equalsIgnoreCase(pSubmitIfEmpty.trim());
    }

    public ContentParam(String pCode, String pName, String pHelp, boolean pMandatory) {
        this.mCode = pCode;
        this.mName = pName;
        this.mHelp = pHelp;
        this.mMandatory = pMandatory;
        this.mTrimValue = false;
        this.mSubmitIfEmpty = false;
    }

    public String getCode() {
        return this.mCode;
    }

    public void setCode(String pCode) {
        this.mCode = pCode;
    }

    public String getHelp() {
        return this.mHelp;
    }

    public void setHelp(String pHelp) {
        this.mHelp = pHelp;
    }

    public boolean isMandatory() {
        return this.mMandatory;
    }

    public void setMandatory(boolean pMandatory) {
        this.mMandatory = pMandatory;
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String pName) {
        this.mName = pName;
    }

    public Object getValue() {
        return this.mValue;
    }

    public void setValue(Object pValue) {
        this.mValue = pValue;
    }

    public boolean isValueTrimmed() {
        return this.mTrimValue;
    }

    public boolean isValueSubmittedIfEmpty() {
        return this.mSubmitIfEmpty;
    }

    public String getProcessedValue() {
        String result = null;
        if (this.mValue != null) {
            result = (String)this.mValue;
            if (this.isValueTrimmed()) {
                result = result.trim();
            }
            if (!this.isValueSubmittedIfEmpty() && result.length() == 0) {
                result = null;
            }
        }
        return result;
    }

    public static Object idcVersionInfo(Object arg) {
        return "releaseInfo=dev,releaseRevision=$Rev: 104567 $";
    }
}

