/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucm.client.odi;

import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.odi.sdk.opentools.IOpenTool;
import oracle.odi.sdk.opentools.IOpenToolParameter;
import oracle.odi.sdk.opentools.OpenToolExecutionException;
import oracle.ucm.client.SearchTool;
import oracle.ucm.client.odi.ContentParam;

public class ContentSearch
extends SearchTool
implements IOpenTool {
    private static ResourceBundle s_messages = null;
    private final IOpenToolParameter[] m_parameters = new IOpenToolParameter[]{new ContentParam("URL", s_messages), new ContentParam("USERNAME", s_messages), new ContentParam("PASSWORD", s_messages), new ContentParam("PASSWORDFILE", s_messages), new ContentParam("SOCKETTIMEOUT", s_messages), new ContentParam("HTTPLIBRARY", s_messages), new ContentParam("JAXWSPOLICY", s_messages), new ContentParam("JPSCONFIGFILE", s_messages), new ContentParam("QUERYTEXT", s_messages), new ContentParam("SORTFIELD", s_messages), new ContentParam("SORTORDER", s_messages), new ContentParam("STARTROW", s_messages), new ContentParam("ENDROW", s_messages), new ContentParam("RESULTCOUNT", s_messages), new ContentParam("WRITEFIELDHEADING", s_messages), new ContentParam("WRITEFIELDNAMES", s_messages), new ContentParam("DELIMITER", s_messages), new ContentParam("DEFAULTFIELDS", s_messages), new ContentParam("OUTPUTFIELDS", s_messages), new ContentParam("PROPERTIES", s_messages), new ContentParam("PROPERTIESFILE", s_messages), new ContentParam("VERBOSE", s_messages), new ContentParam("QUIET", s_messages), new ContentParam("LOG_FILE_NAME", s_messages), new ContentParam("LOG_FILE_APPEND", s_messages)};

    public static String getResourceString(String key) {
        return s_messages.getString(key);
    }

    public static void main(String[] args) {
    }

    public void execute() throws OpenToolExecutionException {
        IOpenToolParameter[] parameters = this.getParameters();
        ArrayList<String> argsList = new ArrayList<String>();
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                IOpenToolParameter p = parameters[i];
                String key = p.getCode();
                Object value = null;
                value = p instanceof ContentParam ? ((ContentParam)p).getProcessedValue() : p.getValue();
                if (value != null) {
                    argsList.add("--" + key + "=" + value);
                    continue;
                }
                if (!p.isMandatory()) continue;
                throw new OpenToolExecutionException("ContentSearch property \"" + key + "\" is mandatory.");
            }
        }
        String[] args = new String[argsList.size()];
        args = argsList.toArray(args);
        try {
            try {
                boolean terminateEarly = this.setup(args);
                if (terminateEarly) {
                    return;
                }
                SearchTool.SearchResults result = this.run();
            }
            catch (Exception e) {
                this.log("\nError - " + e.getMessage());
                if (!this.isSilent() && !this.isQuiet()) {
                    this.log(e);
                }
                throw e;
            }
            finally {
                this.logout();
                this.closeLog();
            }
        }
        catch (Exception e) {
            throw new OpenToolExecutionException("ContentSearch error - " + e.getMessage(), (Throwable)e);
        }
    }

    public String getSyntax() {
        String syntax = ContentSearch.getResourceString("TOOL_Syntax");
        if (syntax == null || syntax.trim().length() == 0) {
            syntax = "ContentSearch";
        }
        return syntax;
    }

    public String getDescription() {
        return ContentSearch.getResourceString("TOOL_Desc");
    }

    public String getVersion() {
        return (String)ContentSearch.idcVersionInfo(null);
    }

    public String getProvider() {
        return "Oracle";
    }

    public String getIcon(int pIconType) {
        switch (pIconType) {
            case 0: {
                return "/oracle/ucm/client/odi/resource/search_16.png";
            }
            case 1: {
                return "/oracle/ucm/client/odi/resource/search_32.png";
            }
        }
        return "";
    }

    public IOpenToolParameter[] getParameters() {
        return this.m_parameters;
    }

    protected final Object getParameterValue(String pParamCode) throws IllegalArgumentException {
        IOpenToolParameter[] parameters = this.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            if (!parameters[i].getCode().equals(pParamCode)) continue;
            return parameters[i].getValue();
        }
        throw new IllegalArgumentException(pParamCode);
    }

    protected final void setParameterValue(String pParamCode, Object pValue) throws IllegalArgumentException {
        IOpenToolParameter[] parameters = this.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            if (!parameters[i].getCode().equals(pParamCode)) continue;
            parameters[i].setValue(pValue);
            return;
        }
        throw new IllegalArgumentException(pParamCode);
    }

    protected String getToolHeader() {
        return this.getProvider() + " - " + this.getDescription() + " - " + this.getVersion();
    }

    public static Object idcVersionInfo(Object arg) {
        return "releaseInfo=dev,releaseRevision=$Rev: 122355 $";
    }

    static {
        ClassLoader loader = ContentSearch.class.getClassLoader();
        Locale defaultLocale = Locale.getDefault();
        s_messages = ResourceBundle.getBundle("oracle/ucm/client/odi/resource/ContentSearch", defaultLocale, loader);
    }
}

