/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucm.client.utils;

import java.io.PrintWriter;
import java.util.Map;
import oracle.stellent.ridc.IdcClientException;
import oracle.stellent.ridc.model.DataBinder;
import oracle.stellent.ridc.model.DataObject;
import oracle.stellent.ridc.model.DataResultSet;
import oracle.stellent.ridc.model.TransferFile;
import oracle.stellent.ridc.protocol.ServiceException;

public class LogUtils {
    public static final String INDENT = "  ";
    public static final String NEWLINE = "\n";
    public static final String LT = "<";
    public static final String GT = ">";
    public static final String HTML_INDENT = "&nbsp;&nbsp;";
    public static final String HTML_NEWLINE = "<br/>";
    public static final String HTML_LT = "&lt;";
    public static final String HTML_GT = "&gt;";
    private String m_indent;
    private String m_newLine;
    private String m_lessThan;
    private String m_greaterThan;
    private PrintWriter m_out;
    private LogFormat m_format;
    private boolean m_closeWriter = true;

    public LogUtils() {
        this(new PrintWriter(System.out, true), false);
    }

    public LogUtils(PrintWriter out) {
        this(out, LogFormat.console, true);
    }

    public LogUtils(PrintWriter out, boolean closeWriter) {
        this(out, LogFormat.console, closeWriter);
    }

    public LogUtils(PrintWriter out, LogFormat format, boolean closeWriter) {
        this.m_out = out;
        this.m_format = format;
        this.setCloseWriter(closeWriter);
        if (format.equals((Object)LogFormat.console)) {
            this.m_indent = INDENT;
            this.m_newLine = NEWLINE;
            this.m_lessThan = LT;
            this.m_greaterThan = GT;
        } else if (format.equals((Object)LogFormat.html)) {
            this.m_indent = HTML_INDENT;
            this.m_newLine = HTML_NEWLINE;
            this.m_lessThan = HTML_LT;
            this.m_greaterThan = HTML_GT;
        }
    }

    public void logDataBinder(DataBinder db, String prefix) {
        if (db == null) {
            this.log(prefix + "** DataBinder is NULL");
            return;
        }
        this.log(prefix + this.m_lessThan + "localdata" + this.m_greaterThan);
        this.logDataObject(db.getLocalData(), prefix + this.m_indent);
        this.log(prefix + this.m_lessThan + "/localdata" + this.m_greaterThan);
        for (String rsName : db.getResultSetNames()) {
            this.log(prefix + this.m_lessThan + "resultset name='" + rsName + "'" + this.m_greaterThan);
            this.logDataResultSet(db.getResultSet(rsName), prefix + this.m_indent);
            this.log(prefix + this.m_lessThan + "/resultset" + this.m_greaterThan);
        }
        if (db.containsFiles()) {
            for (String filename : db.getFileNames()) {
                TransferFile file = db.getFile(filename);
                this.log(prefix + this.m_lessThan + "transferfile='" + filename + "'" + this.m_greaterThan);
                this.log(prefix + this.m_indent + file.getFileName() + " - " + file.getContentLength() + " bytes, type=" + file.getContentType());
                this.log(prefix + this.m_lessThan + "/transferfile" + this.m_greaterThan);
            }
        }
        this.log();
    }

    public void logDataObject(DataObject dataObject, String prefix) {
        if (dataObject == null) {
            this.log(prefix + "** DataObject is NULL");
            return;
        }
        for (Map.Entry entry : dataObject.entrySet()) {
            this.log(prefix + (String)entry.getKey() + "=" + (String)entry.getValue());
        }
    }

    public void logDataResultSet(DataResultSet rs, String prefix) {
        if (rs == null) {
            this.log(prefix + "** DataResultSet is NULL");
            return;
        }
        int index = 0;
        for (DataObject dataObject : rs.getRows()) {
            this.log(prefix + this.m_lessThan + "row index=" + index++ + this.m_greaterThan);
            this.logDataObject(dataObject, prefix + this.m_indent);
            this.log(prefix + this.m_lessThan + "/row" + this.m_greaterThan);
        }
    }

    public void logException(Exception e) {
        if (e instanceof IdcClientException) {
            this.logRidcException((IdcClientException)e);
        } else {
            Throwable cause;
            e.printStackTrace(this.m_out);
            this.log(this.m_newLine);
            for (cause = e.getCause(); cause != null && !(cause instanceof IdcClientException); cause = cause.getCause()) {
            }
            if (cause != null && cause instanceof IdcClientException) {
                this.logRidcException((IdcClientException)cause);
            }
        }
    }

    public void logRidcException(IdcClientException e) {
        this.log(this.m_newLine + "IdcClientException Caught ...");
        e.printStackTrace(this.m_out);
        this.log(this.m_newLine);
        if (e instanceof ServiceException) {
            this.log(this.m_newLine + "ServiceException DataBinder:");
            this.logDataBinder(((ServiceException)e).getBinder(), this.m_indent);
        }
    }

    public void log() {
        this.log(null);
    }

    public void log(String message) {
        this.m_out.print(message == null ? this.m_newLine : message + this.m_newLine);
        this.m_out.flush();
    }

    public void print(String message) {
        this.m_out.print(message);
        this.m_out.flush();
    }

    public String getDefaultIndent() {
        return this.m_indent;
    }

    public PrintWriter getPrintWriter() {
        return this.m_out;
    }

    public void close() {
        PrintWriter writer = this.getPrintWriter();
        writer.flush();
        if (this.isCloseWriter()) {
            writer.close();
        }
    }

    public void setCloseWriter(boolean closeWriter) {
        this.m_closeWriter = closeWriter;
    }

    public boolean isCloseWriter() {
        return this.m_closeWriter;
    }

    public static Object idcVersionInfo(Object arg) {
        return "releaseInfo=dev,releaseRevision=$Rev: 122351 $";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LogFormat {
        console,
        html;

    }
}

