/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucm.client.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProgramOptionsProcessor {
    private Map<String, String> m_options = new LinkedHashMap<String, String>();
    private static final String PROP_EXT = ".properties";
    private static final int PROP_EXT_LENGTH = ".properties".length();
    private Set<String> m_restrictedOptions = new HashSet<String>();

    public ProgramOptionsProcessor() {
    }

    public ProgramOptionsProcessor(String[] args) {
        boolean overwriteExisting = true;
        this.load(args, overwriteExisting);
    }

    public boolean containsKey(String ... keys) {
        for (String key : this.m_options.keySet()) {
            if (keys == null) continue;
            for (String k : keys) {
                if (!key.equalsIgnoreCase(k)) continue;
                return true;
            }
        }
        return false;
    }

    public String get(String ... keys) {
        if (keys != null) {
            for (String key : keys) {
                String value;
                if (key == null || (value = this.m_options.get(key.toUpperCase())) == null) continue;
                return value;
            }
        }
        return null;
    }

    public String put(String key, String value) {
        if (key != null) {
            return this.m_options.put(key.toUpperCase(), value == null ? "" : value);
        }
        throw new IllegalArgumentException("key is null.");
    }

    public String remove(String key) {
        if (key != null) {
            return this.m_options.remove(key.toUpperCase());
        }
        throw new IllegalArgumentException("key is null.");
    }

    public Set<String> getKeys() {
        return new HashSet<String>(this.m_options.keySet());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String key : this.m_options.keySet()) {
            if (this.m_restrictedOptions.contains(key)) continue;
            sb.append(sb.length() > 0 ? "\n" : "");
            String value = "PASSWORD".equals(key) || "PROXYPASSWORD".equals(key) || "HTTP.PROXYPASSWORD".equals(key) ? "*" : this.m_options.get(key);
            sb.append(key).append("=").append(value);
        }
        return sb.toString();
    }

    public void load(String[] args, boolean overwriteExisting) {
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                String key = args[i];
                String value = "";
                if (key == null) continue;
                int equalsPosition = -1;
                equalsPosition = key.indexOf("=");
                if (equalsPosition > 0) {
                    value = key.substring(equalsPosition + 1);
                    key = key.substring(0, equalsPosition);
                }
                String processedKey = null;
                if ((key = key.trim()).startsWith("--") && key.length() > 2) {
                    processedKey = key.substring(2);
                } else if (key.startsWith("-") && key.length() > 1) {
                    processedKey = key.substring(1);
                } else if (key.length() > 0) {
                    processedKey = key;
                }
                if (processedKey == null || this.m_restrictedOptions.contains(processedKey = processedKey.toUpperCase()) || this.containsKey(processedKey) && !overwriteExisting) continue;
                this.m_options.put(processedKey, value);
            }
        }
    }

    public void load(Properties properties, boolean overwriteExisting) {
        if (properties == null) {
            throw new IllegalArgumentException("Properties is null.");
        }
        for (String key : properties.stringPropertyNames()) {
            if (key == null || key.length() <= 0) continue;
            String value = properties.getProperty(key);
            if (this.m_restrictedOptions.contains(key = key.toUpperCase()) || this.containsKey(key) && !overwriteExisting) continue;
            this.m_options.put(key, value == null ? "" : value);
        }
    }

    public void load(InputStream in, boolean overwriteExisting) {
        if (in == null) {
            throw new IllegalArgumentException("InputStream is null.");
        }
        try {
            Properties properties = new Properties();
            properties.load(in);
            this.load(properties, overwriteExisting);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error reading properties from stream.", e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    public void load(File file, boolean overwriteExisting) {
        if (file == null) {
            throw new IllegalArgumentException("File is null.");
        }
        if (!(file.exists() && file.isFile() && file.canRead())) {
            throw new IllegalArgumentException("file '" + file + "' cannot be read.");
        }
        try {
            this.load(new FileInputStream(file), overwriteExisting);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("file '" + file + "' was not found.", e);
        }
    }

    public void load(String resource, boolean overwriteExisting) {
        if (resource == null) {
            throw new IllegalArgumentException("Resource is null.");
        }
        String processedResource = resource;
        if (processedResource.endsWith(PROP_EXT)) {
            processedResource = processedResource.substring(0, resource.length() - PROP_EXT_LENGTH);
        }
        if ((processedResource = processedResource.replace('.', '/')).startsWith("/")) {
            processedResource = processedResource.substring(1);
        }
        processedResource = processedResource + PROP_EXT;
        Class<?> cls = this.getClass();
        ClassLoader loader = cls.getClassLoader();
        InputStream in = loader.getResourceAsStream(processedResource);
        if (in == null) {
            throw new IllegalArgumentException("Resource could not be loaded '" + processedResource + "' (originally specified as '" + resource + "')");
        }
        this.load(in, overwriteExisting);
    }

    public void setRestrictedOptions(Set<String> options) {
        this.m_restrictedOptions = options;
    }

    protected Set<String> getRestrictedOptions() {
        return this.m_restrictedOptions;
    }

    protected Map<String, String> getOptionsMap() {
        return this.m_options;
    }

    public void setSystemProperties() {
        for (int i = 0; i < 10; ++i) {
            String argkey = "SK" + i;
            String argval = "SV" + i;
            if (!this.m_options.containsKey(argkey) || !this.m_options.containsKey(argval)) continue;
            String key = this.m_options.get(argkey);
            String value = this.m_options.get(argval);
            System.setProperty(key, value);
        }
    }

    public static Object idcVersionInfo(Object arg) {
        return "releaseInfo=dev,releaseRevision=$Rev: 114141 $";
    }
}

