/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucm.client.utils;

import oracle.ucm.client.utils.ClientUtils;
import oracle.ucm.client.utils.ProgramOptionsProcessor;

public class SearchUtils {
    public static void processDateNumberQueryParam(ProgramOptionsProcessor op, StringBuilder queryBuilder, String ... keys) {
        String ne;
        String gte;
        String lte;
        String primary = keys[0];
        String[] equals = new String[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            equals[i] = keys[i];
        }
        String[] lessthanequals = new String[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            lessthanequals[i] = keys[i] + "<";
        }
        String[] greaterthanequals = new String[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            greaterthanequals[i] = keys[i] + ">";
        }
        String[] notequals = new String[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            notequals[i] = keys[i] + "!";
        }
        String equal = ClientUtils.getStringIfPostTrimNonEmpty(op.get(equals));
        if (equal != null) {
            if (queryBuilder.length() > 0) {
                queryBuilder.append(" <AND> ");
            }
            queryBuilder.append(primary).append(" = `").append(equal).append("`");
        }
        if ((lte = ClientUtils.getStringIfPostTrimNonEmpty(op.get(lessthanequals))) != null) {
            if (queryBuilder.length() > 0) {
                queryBuilder.append(" <AND> ");
            }
            queryBuilder.append(primary).append(" <= `").append(lte).append("`");
        }
        if ((gte = ClientUtils.getStringIfPostTrimNonEmpty(op.get(greaterthanequals))) != null) {
            if (queryBuilder.length() > 0) {
                queryBuilder.append(" <AND> ");
            }
            queryBuilder.append(primary).append(" >= `").append(gte).append("`");
        }
        if ((ne = ClientUtils.getStringIfPostTrimNonEmpty(op.get(notequals))) != null) {
            if (queryBuilder.length() > 0) {
                queryBuilder.append(" <AND> ");
            }
            queryBuilder.append("(<NOT> (").append(primary).append(" = `").append(ne).append("`))");
        }
    }

    public static void processStringQueryParam(ProgramOptionsProcessor op, StringBuilder queryBuilder, String ... keys) {
        boolean trimValue = true;
        boolean emptyValid = false;
        SearchUtils.processStringQueryParam(op, queryBuilder, trimValue, emptyValid, keys);
    }

    public static void processStringQueryParam(ProgramOptionsProcessor op, StringBuilder queryBuilder, boolean trimValue, boolean emptyValid, String ... keys) {
        String exactEqual;
        String end;
        String start;
        String notsubstring;
        String substring;
        String notmatch;
        String primary = keys[0];
        String[] matches = new String[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            matches[i] = keys[i];
        }
        String[] notmatches = new String[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            notmatches[i] = keys[i] + "!";
        }
        String[] substrings = new String[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            substrings[i] = keys[i] + "%";
        }
        String[] notsubstrings = new String[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            notsubstrings[i] = keys[i] + "!%";
        }
        String[] starts = new String[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            starts[i] = keys[i] + "^";
        }
        String[] ends = new String[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            ends[i] = keys[i] + "$";
        }
        String[] exactEquals = new String[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            exactEquals[i] = keys[i] + ":";
        }
        String match = ClientUtils.getStringProcessed(op.get(matches), trimValue, emptyValid);
        if (match != null) {
            if (queryBuilder.length() > 0) {
                queryBuilder.append(" <AND> ");
            }
            queryBuilder.append(primary).append(" <matches> `").append(match).append("`");
        }
        if ((notmatch = ClientUtils.getStringProcessed(op.get(notmatches), trimValue, emptyValid)) != null) {
            if (queryBuilder.length() > 0) {
                queryBuilder.append(" <AND> ");
            }
            queryBuilder.append("(<NOT> (").append(primary).append(" <matches> `").append(notmatch).append("`))");
        }
        if ((substring = ClientUtils.getStringProcessed(op.get(substrings), trimValue, emptyValid)) != null) {
            if (queryBuilder.length() > 0) {
                queryBuilder.append(" <AND> ");
            }
            queryBuilder.append(primary).append(" <substring> `").append(substring).append("`");
        }
        if ((notsubstring = ClientUtils.getStringProcessed(op.get(notsubstrings), trimValue, emptyValid)) != null) {
            if (queryBuilder.length() > 0) {
                queryBuilder.append(" <AND> ");
            }
            queryBuilder.append("(<NOT> (").append(primary).append(" <substring> `").append(notsubstring).append("`))");
        }
        if ((start = ClientUtils.getStringProcessed(op.get(starts), trimValue, emptyValid)) != null) {
            if (queryBuilder.length() > 0) {
                queryBuilder.append(" <AND> ");
            }
            queryBuilder.append(primary).append(" <starts> `").append(start).append("`");
        }
        if ((end = ClientUtils.getStringProcessed(op.get(ends), trimValue, emptyValid)) != null) {
            if (queryBuilder.length() > 0) {
                queryBuilder.append(" <AND> ");
            }
            queryBuilder.append(primary).append(" <ends> `").append(end).append("`");
        }
        if ((exactEqual = ClientUtils.getStringProcessed(op.get(exactEquals), trimValue, emptyValid)) != null) {
            if (queryBuilder.length() > 0) {
                queryBuilder.append(" <AND> ");
            }
            queryBuilder.append(primary).append(" = `'").append(exactEqual).append("'`");
        }
    }

    public static Object idcVersionInfo(Object arg) {
        return "releaseInfo=dev,releaseRevision=$Rev: 122351 $";
    }
}

