#/bin/bash
# Copyright (c) 2017 Oracle and/or its affiliates. All rights reserved
#
# ujanke: 2017/08/30 initial release
#
# This script searches for MANIFEST.MF files in UCM. If a data extraction has been previously completely downloaded
# it will skip those. By this script files will be downloaded into a directory ../export/<UCM DocID of MANIFEST.MF>. After a
# complete download a file named "download.complete" being created in that directory. It will be taken as an indicator for a completed download.
# The script reads the content of downloaded MANIFEST.MF file and downloads the zipped data extraction files belonging to this
# data extraction run. As the MANIFEST.MF file lists the MD5 checksum for every single file this script also compares these
# values to validate the correct download.
#
# Deletion of downloaded data extracts is not handled by this script.
#


java -jar ridc/oracle.ucm.fa_client_11.1.1.jar SearchTool \
--SortField=dID \
--SortOrder=asc \
--quiet --propertiesFile=./connection.properties \
--log_file_name=logs/manifestSearchResults.txt \
--simpleRIDCLogging \
--dDocTitle="MANIFEST.MF" \
--dSecurityGroup="OBIAImport" \
--delimiter=, \
--fields=dID,dDocName,dInDate,dOriginalName,VaultFileSize --defaultFields=false >logs/manifestSearchResults.log 2>logs/manifestSearchResults.err

numRows=`cat logs/manifestSearchResults.txt | wc -l`
numRecs=`cat logs/manifestSearchResults.txt | awk -v lastRow="$numRows" '{ if (FNR == lastRow) printf("%d\n", $1); }'`

echo "Number of Rows: ${numRecs}"
if [ ${numRecs} -eq 0 ]
then
    echo "No data available! Finishing ..."
    exit 255
else
    echo "Running the download of recent BIACM extracts for ${numRecs} record(s) ..."
fi

i=1
while [ $i -le $numRecs ]
do
    currDocId=`cat logs/manifestSearchResults.txt | awk -v "current=$i" '{ if (NR == (2 + current)) print $0 }' | awk -F, '{print $1}'`
    currDocDate=`cat logs/manifestSearchResults.txt | awk -v "current=$i" '{ if (NR == (2 + current)) print $0 }' | awk -F, '{print $3}'`

    echo "   >> Saving Manifest file with UCM Doc ID    : ${currDocId}"
    echo "   >> Saving Files from Extraction Date       : ${currDocDate}"

    if [ ! -d ../export/${currDocId} ]
    then
    	mkdir ../export/${currDocId}
    fi
    
    if [ ! -f ../export/${currDocId}/download.complete ]
    then
        echo "     Will extract data into directory `pwd`/../export/${currDocId}"

        java -jar ridc/oracle.ucm.fa_client_11.1.1.jar DownloadTool \
         	 --propertiesFile=./connection.properties \
               	 --log_file_name=logs/manifestDownload.txt \
		 --outputDir=../export/$currDocId --md5 --md5lowercase \
               	 --dID=$currDocId --RevisionSelectionMethod Latest

        for a in `cat ../export/$currDocId/MANIFEST.MF | awk '{ if (NR > 1) print $0}'`
        do	
            nextFileName=`echo $a | awk -F\; '{print $1}'`
            nextDocId=`echo $a | awk -F\; '{print $2}'`
            nextMD5Val=`echo $a | awk -F\; '{print $3}'`

            echo "      >> Downloading file ${nextFileName} with Document ID ${nextDocId} ..."

            java -jar ridc/oracle.ucm.fa_client_11.1.1.jar DownloadTool \
              	   --propertiesFile=./connection.properties \
               	   --log_file_name=logs/fileDownload.txt \
		   --outputDir=../export/$currDocId --md5 --md5lowercase \
               	   --dID=$nextDocId --RevisionSelectionMethod Latest

            downldMD5=`cat logs/fileDownload.txt | grep MD5 | awk -F= '{print $2}' | awk -F\] '{print $1}'`
		
            if [ $nextMD5Val != $downldMD5 ]
            then
		echo "Error: MD5 checksum value for downloaded file is incorrect!"
		echo "Exiting!"
            fi
        done
        echo "`date +%Y%m%d%H%M%S`" > ../export/$currDocId/download.complete
        echo "   Done! Data Extract downloaded into directory `pwd`/../export/${currDocId}!"
    else
        echo "   Not downloading  extract data into directory `pwd`/../export/${currDocId} as previously downloaded on `cat ../export/${currDocId}/download.complete`"
    fi

    echo "-----------------------------------------------------------------------------------------"
    echo ""

    i=`expr $i + 1`
done
