import java.util.ArrayList;
import java.util.List;

import java.util.Map;

import oracle.ucm.client.DownloadTool;

import oracle.ucm.client.DownloadTool.DownloadResult;

import oracle.ucm.client.SearchTool;

import oracle.ucm.client.SearchTool.SearchResult;
import oracle.ucm.client.SearchTool.SearchResults;

import oracle.ucm.client.UploadTool;

import oracle.ucm.client.UploadTool.UploadResults;

import oracle.ucm.client.bulk.UploadException;

import oracle.ucm.client.model.response.CheckinResponse;

import oracle.ucm.client.utils.ProgramOptionsProcessor;

/**
 * WebCenter Content RIDC-based Transfer Tools
 * Programmatic Invocation Test
 */
public class RidcToolTest
{
	public static void main(String[] args)
	{
		List<String> coreArgs = new ArrayList<String>();
		coreArgs.add("url=https://UpdateThisValue.com/cs/idcplg");
		coreArgs.add("username=weblogic");
		coreArgs.add("password=welcome1");
		coreArgs.add("silent=true"); // minimal log output
		// coreArgs.add("verbose=true"); // verbose log output

		List<String> argsList = null;

		argsList = new ArrayList<String>();
		argsList.addAll(coreArgs);
		argsList.add("tool.accountrequired=false");
		argsList.add("dSecurityGroup=Public");
		argsList.add("directory=/C:/Users/mshannon/Desktop/Test");
		argsList.add("threads=5");
		argsList.add("throwOnThreadException=false"); // run() will not throw an exception should a thread error

		String[] uploadArgs = argsList.toArray(new String[0]);

		argsList = new ArrayList<String>();
		argsList.addAll(coreArgs);
		argsList.add("QueryText=dSecurityGroup = `'Public'`"); // explicit query
		argsList.add("SortField=dID");
		argsList.add("SortOrder=DESC");
		argsList.add("ResultCount=5"); // Maximum number of search results to return.

		String[] searchArgs = argsList.toArray(new String[0]);

		argsList = new ArrayList<String>();
		argsList.addAll(coreArgs);
		argsList.add("md5Only=true"); // Return an MD5 message-digest of the downloaded stream as a 32 digit hexadecimal
		argsList.add("md5lowercase=true"); // Return MD5 message-digest in lower-case

		String[] downloadArgs = argsList.toArray(new String[0]);

		try
		{
			UploadTool uploadTool = new UploadTool();
			SearchTool searchTool = new SearchTool();
			DownloadTool downloadTool = new DownloadTool();
			try
			{
				// Setup the tool's initial configuration from the supplied arguments.
				boolean terminateEarly = uploadTool.setup(uploadArgs);
				if (terminateEarly)
				{
					return;
				}

				// Setup the tool's initial configuration from the supplied arguments.
				terminateEarly = searchTool.setup(searchArgs);

				if (terminateEarly)
				{
					return;
				}

				// Setup the tool's initial configuration from the supplied arguments.
				terminateEarly = downloadTool.setup(downloadArgs);

				if (terminateEarly)
				{
					return;
				}

				UploadResults uploadResults = uploadTool.run();
				if (uploadResults != null)
				{
					Map<Integer, Exception> failedCheckins = uploadResults.getAllFailedCheckinsKeyedByTaskNum();
					Map<Integer, UploadException> failedCheckinsDetailed = uploadResults.getFailedCheckinsKeyedByTaskNum();
					for (Map.Entry<Integer, Exception> entry : failedCheckins.entrySet())
					{
						if (failedCheckinsDetailed.containsKey(entry.getKey()))
						{
							UploadException e = failedCheckinsDetailed.get(entry.getKey());
							System.out.println("Checkin with task number " + e.getTaskNumber() + " and identifier "
								+ e.getIdentifier() + " failed with message " + e.getMessage());
						}
						else
						{
							System.out.println("Checkin with task number " + entry.getKey() + " failed with message "
								+ entry.getValue().getMessage());
						}
					}

					Map<Integer, CheckinResponse> successfulCheckins = uploadResults.getSuccessfulCheckinsKeyedByTaskNum();
					for (Map.Entry<Integer, CheckinResponse> entry : successfulCheckins.entrySet())
					{
						CheckinResponse response = entry.getValue();
						System.out.println("Checkin with task number " + response.getTaskNumber() + " and identifier "
							+ response.getIdentifier() + " succeeded. dID=" + response.getDId());
					}
				}

				SearchResults searchResults = searchTool.run();
				if (searchResults != null)
				{
					for (SearchResult searchResult : searchResults.getResults())
					{
						String dID = searchResult.getDID();
						String dOriginalName = searchResult.getDOriginalName();
						System.out.println("\n" + "Obtaining MD5 of Search Result with dID " + dID + " and original filename "
							+ dOriginalName + " ...");

						ProgramOptionsProcessor processor = downloadTool.getOptionsProcessor();
						processor.put("dID", dID);

						DownloadResult downloadResult = downloadTool.run();
						System.out.println("... MD5 " + downloadResult.getMd5() + " - total bytes read "
							+ downloadResult.getBytesRead());
					}
				}
			}
			catch (Exception e)
			{
				throw e;
			}
			finally
			{
				uploadTool.logout();
				downloadTool.logout();
				searchTool.logout();
			}

			System.exit(0);
		}
		catch (Exception e)
		{
			System.exit(1);
		}

	}
}
