#!/bin/sh

# Commands
DIRNAMECMD=`which dirname`
BASENAMECMD=`which basename`

# export JAVA_HOME=/u01/app/oracle/product/Middleware/jrockit_160_37

# Verify whether required variables are set
if [ -z "${JAVA_HOME}" ]; then
  printf "\n\nError: Set the following environment variables:\n\n"
  printf "JAVA_HOME            (Absolute path to jdk directory)\n\n"
  exit 1
fi

JAVACMD="${JAVA_HOME}/bin/java"

CD="`${DIRNAMECMD} $0`"
LIB="${CD}/oracle.ucm.fa_client_11.1.1.jar"

checkerror()
{
  RESULTCODE=$?
  if [ ${RESULTCODE} -ne 0 ];then
    exit 1
  fi
}

${JAVACMD} -Xms512m \
-jar "${LIB}" \
UploadTool \
-propertiesFile="${CD}/connection.properties" \
"$@"

checkerror
