if [ $# -lt 2 ]
then
	echo "Missing parameter: `basename $0` <BICC Sample File> <BICC DDL File>"
	exit 1
fi

biccCSV=$1
biccDDL=$2
sqlDir=</home/oracle/sql>

if [ ! -f $biccCSV ]
then
	echo "File $biccCSV is not accessible!"
	exit 1
fi

if [ ! -f $biccDDL ]
then
	echo "File $biccDDL is not accessible!"
	exit 1
fi

columnList=`cat $biccCSV | awk '{if (NR == 1) printf("%s\n", $0);}' | awk -F, '{ for (i=1; i<=NF; i++) printf("%s\n", $i);}'`
baseFileName=`basename $biccDDL`
fileName=`echo $baseFileName | awk -F\- '{print $1}' | awk -F. '{print $1}' | awk -F_ '{printf("%s_%s_%s_%s", $2, $3, $4, $5)}'` 
tableName=xxds_ext_${fileName}
scriptName=$sqlDir/cr_${tableName}.sql
echo "drop table ${tableName};" > $scriptName
echo "create table ${tableName} (" >> $scriptName

runCount=1
for columnName in $columnList 
do 
	
	cat $biccDDL | awk -F, -v runC=$runCount -v colName=$columnName ' 
		BEGIN {	if ( runC > 1 ) printf(",\n"); }
		{
			if ( toupper($1) == colName ) 
			{
				printf("\t%s ", $1);
				if ( $3=="VARCHAR" ) 
					printf(" VARCHAR2(%s)", $4); 
				else
				{
					if ( $3=="NUMERIC" )
					{
						if ( $5>0 )
						{
							if ( $6==0 ) 
								printf(" %s(%d)", $3, $5); 
							else
							{
								if ( $6==-127 ) 
									printf(" %s(%d)", $3, $5); 
								else
									printf(" %s(%d)", $3, $5, ($6 * -1)); 
							}
						}
						else
							printf(" %s", $3); 
					}
					else
					{
						printf(" %s", $3); 
					}
				}

				if ( $8=="Yes" ) 
					printf(" NOT NULL"); 
			} 
		}' >> $scriptName
	runCount=`expr $runCount + 1`
done
echo ")" >> $scriptName
echo "  ORGANIZATION EXTERNAL 
        (  
                TYPE ORACLE_LOADER  
                DEFAULT DIRECTORY bicc_import_dir 
                ACCESS PARAMETERS  
                (  
                        records delimited by newline  
                        skip 1 
                        date_cache 0 
                        badfile bicc_import_bad_dir:'${tableName}_%p.bad' 
                        logfile bicc_import_log_dir:'${tableName}_%a_%p.log' 
                        fields terminated by ','  
                        OPTIONALLY ENCLOSED BY '\"' 
                        missing field values are null 
                        (" >> $scriptName
runCount=1
for columnName in $columnList 
do 
	cat $biccDDL | awk -F, -v runC=$runCount -v colName=$columnName ' 
		BEGIN {	if ( runC > 1 ) printf(",\n"); }
		{
			if ( toupper($1) == colName ) 
			{
				printf("\t\t\t\t%s", $1);
				if ( toupper($3) =="DATE" ) 
					printf(" char date_format DATE MASK \"YYYY-MM-DD\""); 
				else
				{
					if ( toupper($3) == "TIMESTAMP" )
						printf(" char date_format TIMESTAMP MASK \"YYYY-MM-DD HH24:MI:SS.FF6\""); 
				}
			} 
		}'  >> $scriptName
	runCount=`expr $runCount + 1`
done
echo "" >> $scriptName
echo "			)" >> $scriptName
echo "		)" >> $scriptName
echo "		LOCATION ('${tableName}.csv')
      	)
      	PARALLEL
        REJECT LIMIT UNLIMITED;
quit;" >> $scriptName

