if [ $# -lt 1 ]
then
        echo "Missing parameter: `basename $0` <BICC DDL File>"
        exit 1
fi

sqlDir=</home/oracle/sql>
biccDDL=$1

if [ ! -f $biccDDL ]
then
        echo "File $biccDDL is not accessible!"
        exit 1
fi

baseFileName=`basename $biccDDL`
fileName=`echo $baseFileName | awk -F\- '{print $1}' | awk -F. '{print $1}' | awk -F_ '{printf("%s_%s_%s_%s", $2, $3, $4, $5)}'`

scriptName=`echo cr_${fileName}.sql`
cat  $biccDDL | awk -F, -v tableName=$fileName \
	'BEGIN {printf("drop table xxds_%s;\ncreate table xxds_%s (\n", tableName, tableName)} 
	{ 
		if ( NR==2 ) printf("\t%s", $1); 
		if ( NR>2 ) printf(",\n\t%s", $1); 
		if ( NR>1 && $3=="VARCHAR" ) 
			printf(" VARCHAR2(%s)", $4); 
		else
		{
			if ( NR>1 && $3=="NUMERIC" )
			{
				if ( $5>0 )
				{
					if ( $6==0 ) 
						printf(" %s(%d)", $3, $5); 
					else
					{
						if ( $6==-127 ) 
							printf(" %s(%d)", $3, $5); 
						else
							printf(" %s(%d)", $3, $5, ($6 * -1)); 
					}
				}
				else
					printf(" %s", $3); 
			}
			else
			{
				if ( NR>1 )
					printf(" %s", $3); 
			}
		}

		if ( NR>1 && $8=="Yes" ) 
		{
			printf(" NOT NULL "); 
			pk_arr[$1]++;
		}	
	} \
	END \
	{ 
		count=0;
		for (key in pk_arr) 
		{ 
			count++;
		}

		if ( count>0 ) 
		{ 
			printf(",\n\tPrimary Key (");
			loopVar=0;
			for (key in pk_arr) 
			{ 
				if ( loopVar>0 ) 
					printf(", %s ", key); 
				else
					printf("%s ", key); 
				loopVar++;
			} 
			printf(")");
		}
		printf("\n);\nquit;\n"); 
	}' > $sqlDir/$scriptName
