## Copyright (c) 2021, Oracle and/or its affiliates.
## All rights reserved. The Universal Permissive License (UPL), Version 1.0 as shown at http://oss.oracle.com/licenses/upl

# User data template
data "template_file" "user_data" {
  template = file("oci-cloud-init.sh")

  vars = {
    username = var.username
    image_operating_system_version = var.image_operating_system_version
    docker_compose_version = var.docker_compose_version
    mount_dir = var.mount_dir
    web_server_port = var.web_server_port
  }
}

# Compute Instances
resource "oci_core_instance" "oci_server" {
  availability_domain = data.oci_identity_availability_domains.ad_list.availability_domains[var.ad -1]["name"]
  compartment_id = var.compartment_ocid
  display_name = var.compute_display_name
  shape = var.instance_shape

  agent_config {
    is_management_disabled = "false"
    is_monitoring_disabled = "false"
    plugins_config {
      desired_state = "DISABLED"
      name = "Vulnerability Scanning"
    }
    plugins_config {
      desired_state = "DISABLED"
      name = "Oracle Java Management Service"
    }
    plugins_config {
      desired_state = "ENABLED"
      name = "OS Management Service Agent"
    }
    plugins_config {
      desired_state = "ENABLED"
      name = "Compute Instance Run Command"
    }
    plugins_config {
      desired_state = "ENABLED"
      name = "Compute Instance Monitoring"
    }
    plugins_config {
      desired_state = "DISABLED"
      name = "Block Volume Management"
    }
    plugins_config {
      desired_state = "DISABLED"
      name = "Bastion"
    }
  }

	availability_config {
		is_live_migration_preferred = true
		recovery_action = "RESTORE_INSTANCE"
	}

	instance_options {
		are_legacy_imds_endpoints_disabled = "false"
	}

  create_vnic_details {
    assign_private_dns_record = true
    assign_public_ip = true
    subnet_id = oci_core_subnet.public_oci_core_subnet.id
    display_name = "primary-vnic"
  }

  source_details {
    source_type = "image"
    source_id = lookup(data.oci_core_images.compute_images.images[0], "id")
  }

  metadata = {
    ssh_authorized_keys = var.ssh_public_key
    user_data = base64encode(data.template_file.user_data.rendered)
  }

}