const fs = require('fs');
const express = require('express');
const app = express();

var extractStats = new Object();
extractStats.voArr  = new Array();

extractStats.voNameArr = new Array(  
        { 
            "voName": "ViewObject Name",
            "detailsLine" : [ { 
                "runDate": "Run Date",
                "status": "Status", 
                "numberOfRows": "Number of Rows", 
                "extractDuration": "Extract Duration In Sec",
                "uploadDuration": "Upload Duration In Sec", 
                "totalDuration": "Total Duration In Sec",
                "queryDuration": "Query Duration In Sec",
                "fileName": "File Name"
            }]});

extractStats.voRunDateArr = new Array(  
        { 
            "voRunDate": "Run Date",
            "detailsLine": [ { 
                "voName": "View Object Name",
                "runDate": "Timestamp",
                "status": "Status", 
                "numberOfRows": "Number of Rows", 
                "extractDuration": "Extract Duration In Sec",
                "uploadDuration": "Upload Duration In Sec", 
                "totalDuration": "Total Duration In Sec",
                "queryDuration": "Query Duration In Sec",
                "fileName": "File Name"
            }]});

extractStats.voFailedArrByDate = new Array(  
        { 
            "voRunDate": "Run Date",
            "detailsLine": [ { 
                "voName": "View Object Name",
                "errMsg": "Error Message",
                "status": "Status", 
                "runDate": "Run Date",
                "numberOfRows": "Number of Rows", 
                "extractDuration": "Extract Duration In Sec",
                "uploadDuration": "Upload Duration In Sec", 
                "totalDuration": "Total Duration In Sec",
                "queryDuration": "Query Duration In Sec",
                "fileName": "File Name"
            }]});

extractStats.voFailedArrByVO = new Array(  
        { 
            "voName": "ViewObject Name",
            "detailsLine": [ { 
                "runDate": "Run Date",
                "status": "Status", 
                "errMsg": "Error Message",
                "numberOfRows": "Number of Rows", 
                "extractDuration": "Extract Duration In Sec",
                "uploadDuration": "Upload Duration In Sec", 
                "totalDuration": "Total Duration In Sec",
                "queryDuration": "Query Duration In Sec",
                "fileName": "File Name"
            }]});

extractStats.voJobIDArr = new Array(  
        { 
            "voSchedID": "Schedule ID",
            "reqIDList": [ { 
                "reqID": "Request ID",
                "detailsLine": [ { 
                    "voName": "View Object Name",
                    "runDate": "Timestamp",
                    "status": "Status", 
                    "numberOfRows": "Number of Rows", 
                    "extractDuration": "Extract Duration In Sec",
                    "uploadDuration": "Upload Duration In Sec", 
                    "totalDuration": "Total Duration In Sec",
                    "queryDuration": "Query Duration In Sec",
                    "fileName": "File Name"
            }]
        }]
    });

extractStats.reportStats = new Array(  
        { 
            "oldestRunDate": "Oldest Extraction Date/Time",
            "recentRunDate": "Latest Extraction Date/Time",
            "totalNumOfRowsInLogs": "Total Number or Extracted Rows Found",
            "scheduleIDArr": [{ "scheduleID": "Number of Batch Schedules Found"}],
            "requestIDArr": [{ "requestID": "Number of Jobs Found"}],
            "fileListArr": [{fileName: "Processed File List"}],
            "voListArr": [{voName: "Processed VO List"}]
    });

extractStats.statusSuccess = "SUCCESS";
extractStats.htmlTitle = "Monitoring BICC Extract Logs";
extractStats.htmlHeader = "<!DOCTYPE html>" +
                    "<html>" + 
                    "<head>" + 
                    "<meta charset='utf-8'>" +
                    "<style> " +
                        "table{ width:100%; border-collapse: collapse; }" +
                        "td, tr {border: 0px solid;border-space: 5px;overflow:hidden;vertical-align:top;text-align:left;padding:5px;} " +
                        "th {border: 0; pxfont-size:15px; background:#0d0b98; color:#f2e931; font-family:arial; letter-spacing:2px; padding:5px; text-align:left; vertical-align:center;}" + 
                    "</style>";

extractStats.rootHtmlHeader = "<head>" +
		"<meta charset='utf-8'>" +
		"<title>" + extractStats.htmlTitle + "</title>" +
		"<style>" +
		"	table{ width:100%; border-collapse: collapse; }" +
		"	th, td, tr {border: 0px solid;border-space: 5px;overflow:hidden;vertical-align:top;text-align:left}" +
		"	iframe {" +
		"		display: block;" +
		"		border: none;" +
		"		height: 100vh;" +
		"		width: 100vw;" +
		"	}" +
		"	.submit {" +
		"	    text-align: center;" +
		"	}" +
		"	.submit button {" +
		"	    color: white;" +
		"	    background-color: #5A827F;" +
		"	    padding: 5px 11px;" +
		"	    font-family: arial;" +
                "           font-size: 100%;" +
		"	    border-style: 2px solid red" +
		"	}" +
		"	.submit button:hover {" +
		"	    border-color: white;" +
		"	}" +
		"</style>" +
	"<script>" +
	"	function showStats(paramUrl) {" +
	"		    var myIF = document.getElementById('if1').src=paramUrl;" +
	"	};" +
	"</script>" +
	"</head>";

extractStats.handleData = function(recVal, arrCounter, fileName)
{
        var numEntries = recVal.statuses.length;
        var voSubArr = new Array();
        
        for(fileLine = 0; fileLine < numEntries; fileLine++ ) 
        {
            var myRec = recVal.statuses[fileLine];
            var nameVal = myRec.name;
            var statusVal = myRec.status;
            var errorMessage = myRec.errorMessage;
            var rowCountVal = myRec.rowCount;
            var runDateVal = myRec.runDate;
            var queryDurationInSecVal = myRec.queryDurationInSec;
            var extractDurationInSecVal = myRec.extractDurationInSec;
            var uploadDurationInSecVal = myRec.uploadDurationInSec;
            var totalDurationInSecVal = myRec.totalDurationInSec;
            
            voSubArr[fileLine] = [nameVal, runDateVal, statusVal, rowCountVal, extractDurationInSecVal,
                uploadDurationInSecVal, totalDurationInSecVal, queryDurationInSecVal, fileName];
            
            if (statusVal !== this.statusSuccess)
            {
                this.fillFailedArrays(nameVal, runDateVal, statusVal, errorMessage, rowCountVal, extractDurationInSecVal,
                    uploadDurationInSecVal, totalDurationInSecVal, queryDurationInSecVal, fileName);
            }
        }
        this.voArr[arrCounter] = voSubArr.sort();
        this.voArr.sort();
    
};

extractStats.createArrays = function()
{
    var i = 0;
    
    while(i < this.voArr.length){
        var x = 0;
        while(x < this.voArr[i].length){
            var localVOName = this.voArr[i][x][0];
            var localRunDate = this.voArr[i][x][1];
            var localStatus = this.voArr[i][x][2];
            var localNumberOfRows = this.voArr[i][x][3];
            var localExtractDuration = this.voArr[i][x][4];
            var localUploadDuration = this.voArr[i][x][5];
            var localTotalDuration = this.voArr[i][x][6];
            var localQueryDuration = this.voArr[i][x][7];
            var localFileName = this.voArr[i][x][8];
            
            this.fillVONameArr(localVOName, localRunDate, localStatus,
                localNumberOfRows, localExtractDuration, localUploadDuration,
                localTotalDuration, localQueryDuration,localFileName);

            this.fillRunDateArr(localVOName, localRunDate, localStatus,
                localNumberOfRows, localExtractDuration, localUploadDuration,
                localTotalDuration, localQueryDuration,localFileName);
                
            this.fillReportStatsArr(localVOName, localRunDate, localStatus,
                localNumberOfRows, localExtractDuration, localUploadDuration,
                localTotalDuration, localQueryDuration,localFileName);

            this.fillBatchJobArr(localVOName, localRunDate, localStatus,
                localNumberOfRows, localExtractDuration, localUploadDuration,
                localTotalDuration, localQueryDuration,localFileName);

            x = x + 1;
        }
        i = i + 1;
    }
};

extractStats.getScheduleID = function(fileName)
{
    const scheduleName = "SCHEDULE";
    const delimiter = "_";
    var posScheduleStart = fileName.toString().indexOf(scheduleName) + scheduleName.length + delimiter.length;
    var posScheduleEnd = fileName.toString().indexOf(delimiter, posScheduleStart);

    return(fileName.toString().substring(posScheduleStart, posScheduleEnd));

};

extractStats.getRequestID = function(fileName)
{
    const requestName = "REQUEST";
    const delimiter = "_";
    const endDelimiter = ".JSON";
    var posRequestStart = fileName.toString().indexOf(requestName) + requestName.length + delimiter.length;
    var posRequestEnd = fileName.toString().indexOf(endDelimiter, posRequestStart);

    return(fileName.toString().substring(posRequestStart, posRequestEnd));
};

extractStats.fillVONameArr = function(paramVOName, paramRunDate, paramStatus,
                paramNumberOfRows, paramExtractDuration, paramUploadDuration,
                paramTotalDuration, paramQueryDuration, paramFileName)
{
    var posVOName = -1;
    for( v=0; v < this.voNameArr.length; v++){
        if( this.voNameArr[v].voName === paramVOName)
        {
            posVOName = v;
            break;
        }
    }

    if(posVOName < 0)
    {
        this.voNameArr.push({voName: paramVOName});
        posVOName = this.voNameArr.length - 1;
    }
            
    if (Array.isArray(this.voNameArr[posVOName].detailsLine))
    {
                this.voNameArr[posVOName].detailsLine.push({runDate: paramRunDate, status: paramStatus, numberOfRows : paramNumberOfRows,
                    extractDuration : paramExtractDuration, uploadDuration : paramUploadDuration, totalDuration : paramTotalDuration, 
                    queryDuration : paramQueryDuration, fileName : paramFileName});
    } 
    else
    {
        this.voNameArr[posVOName].detailsLine = [{runDate: paramRunDate, status: paramStatus, numberOfRows : paramNumberOfRows,
            extractDuration : paramExtractDuration, uploadDuration : paramUploadDuration, totalDuration : paramTotalDuration, 
            queryDuration : paramQueryDuration, fileName : paramFileName}];
    }
}; 

extractStats.fillRunDateArr = function(paramVOName, paramRunDate, paramStatus,
                paramNumberOfRows, paramExtractDuration, paramUploadDuration,
                paramTotalDuration, paramQueryDuration, paramFileName)
{
    var posRDTSVal = -1;
    var runDateToSec = paramRunDate.toLocaleString().substr(0,19);
    
    for( v=0; v < this.voRunDateArr.length; v++){
        if( this.voRunDateArr[v].voRunDate === runDateToSec)
        {
            posRDTSVal = v;
            break;
        }
    }

    if(posRDTSVal < 0)
    {
        this.voRunDateArr.push({voRunDate: runDateToSec});
        posRDTSVal = this.voRunDateArr.length - 1;
    }
            
    if (Array.isArray(this.voRunDateArr[posRDTSVal].detailsLine))
    {
        this.voRunDateArr[posRDTSVal].detailsLine.push({voName : paramVOName, runDate: paramRunDate, status: paramStatus, numberOfRows : paramNumberOfRows,
            extractDuration : paramExtractDuration, uploadDuration : paramUploadDuration, totalDuration : paramTotalDuration, 
            queryDuration : paramQueryDuration, fileName : paramFileName});
    } 
    else
    {
        this.voRunDateArr[posRDTSVal].detailsLine = [{voName : paramVOName, runDate: paramRunDate, status: paramStatus, numberOfRows : paramNumberOfRows,
            extractDuration : paramExtractDuration, uploadDuration : paramUploadDuration, totalDuration : paramTotalDuration, 
            queryDuration : paramQueryDuration, fileName : paramFileName}];
    }
};

extractStats.fillBatchJobArr = function(paramVOName, paramRunDate, paramStatus,
                paramNumberOfRows, paramExtractDuration, paramUploadDuration,
                paramTotalDuration, paramQueryDuration, paramFileName)
{
    var scheduleID = this.getScheduleID(paramFileName);
    var requestID = this.getRequestID(paramFileName);
    
    var posSchedID = -1;
    var posReqID = -1;
    for( v=0; v < this.voJobIDArr.length; v++){
        if( this.voJobIDArr[v].voSchedID === scheduleID)
        {
            posSchedID = v;
            break;
        }
    }

    if(posSchedID < 0)
    {
        this.voJobIDArr.push({voSchedID: scheduleID});
        posSchedID = this.voJobIDArr.length - 1;
    }

    if (Array.isArray(this.voJobIDArr[posSchedID].reqIDList) )
    {
        for( v=0; v < this.voJobIDArr[posSchedID].reqIDList.length; v++){
            if( this.voJobIDArr[posSchedID].reqIDList[v].reqID === requestID)
            {
                posReqID = v;
                break;
            }
        }
    }

    if(posReqID < 0)
    {
        if (Array.isArray(this.voJobIDArr[posSchedID].reqIDList))
        {
            this.voJobIDArr[posSchedID].reqIDList.push({reqID: requestID});
            posReqID = this.voJobIDArr[posSchedID].reqIDList.length - 1;
        }
        else
        {
            this.voJobIDArr[posSchedID].reqIDList = [{reqID: requestID}];
            posReqID = 0;
        }
    }

    if (Array.isArray(this.voJobIDArr[posSchedID].reqIDList[posReqID].detailsLine))
    {
                this.voJobIDArr[posSchedID].reqIDList[posReqID].detailsLine.push({voName: paramVOName, runDate: paramRunDate, status: paramStatus, numberOfRows : paramNumberOfRows,
                    extractDuration : paramExtractDuration, uploadDuration : paramUploadDuration, totalDuration : paramTotalDuration, 
                    queryDuration : paramQueryDuration, fileName : paramFileName});
    } 
    else
    {
        this.voJobIDArr[posSchedID].reqIDList[posReqID].detailsLine = [{voName: paramVOName,runDate: paramRunDate, status: paramStatus, numberOfRows : paramNumberOfRows,
            extractDuration : paramExtractDuration, uploadDuration : paramUploadDuration, totalDuration : paramTotalDuration, 
            queryDuration : paramQueryDuration, fileName : paramFileName}];
    }
};
    
extractStats.fillReportStatsArr = function(paramVOName, paramRunDate, paramStatus,
                paramNumberOfRows, paramExtractDuration, paramUploadDuration,
                paramTotalDuration, paramQueryDuration, paramFileName)
{
    var localScheduleID = extractStats.getScheduleID(paramFileName);
    var localRequestID = extractStats.getRequestID(paramFileName);
    
    if(this.reportStats.length === 1)
    {
        this.reportStats.push({oldestRunDate: paramRunDate, recentRunDate: paramRunDate,
            totalNumOfRowsInLogs: paramNumberOfRows});

        if (Array.isArray(this.reportStats[1].fileListArr))
            this.reportStats[1].fileListArr.push({fileName: paramFileName});
        else
            this.reportStats[1].fileListArr= [{fileName: paramFileName}];

        if (Array.isArray(this.reportStats[1].voListArr))
            this.reportStats[1].voListArr.push({voName: paramVOName});
        else
            this.reportStats[1].voListArr= [{voName: paramVOName}];

        if (Array.isArray(this.reportStats[1].scheduleIDArr))
            this.reportStats[1].scheduleIDArr.push({scheduleID: localScheduleID});
        else
            this.reportStats[1].scheduleIDArr= [{scheduleID: localScheduleID}];

        if (Array.isArray(this.reportStats[1].requestIDArr))
            this.reportStats[1].requestIDArr.push({requestID: localRequestID});
        else
            this.reportStats[1].requestIDArr= [{requestID: localRequestID}];
    }
    else
    {
        if(this.reportStats[1].oldestRunDate.toString().replace("T", "").replace("Z", "") > paramRunDate.toString().replace("T", "").replace("Z", ""))
            this.reportStats[1].oldestRunDate = paramRunDate;

        if(this.reportStats[1].recentRunDate.toString().replace("T", "").replace("Z", "") < paramRunDate.toString().replace("T", "").replace("Z", ""))
            this.reportStats[1].recentRunDate = paramRunDate;

        var localNumOfRows = parseInt(this.reportStats[1].totalNumOfRowsInLogs.toString()) + parseInt(paramNumberOfRows.toString());
        this.reportStats[1].totalNumOfRowsInLogs = localNumOfRows.toString();

        var valNotFound = true;
        var x = 0;
        
         while(x < this.reportStats[1].fileListArr.length)
        {
            if (this.reportStats[1].fileListArr[x].fileName === paramFileName)
            {
                valNotFound = false;
                break;
            }
            x++;
        };
        
        if(valNotFound)
            this.reportStats[1].fileListArr.push({fileName:paramFileName});
        
        valNotFound = true;
        x = 0;

        while(x < this.reportStats[1].voListArr.length)
        {
            if (this.reportStats[1].voListArr[x].voName === paramVOName)
            {
                valNotFound = false;
                break;
            }
            x++;
        };
        
        if(valNotFound)
            this.reportStats[1].voListArr.push({voName : paramVOName});

        valNotFound = true;
        x = 0;

        while(x < this.reportStats[1].scheduleIDArr.length)
        {
            if (this.reportStats[1].scheduleIDArr[x].scheduleID === localScheduleID)
            {
                valNotFound = false;
                break;
            }
            x++;
        };
        
        if(valNotFound)
            this.reportStats[1].scheduleIDArr.push({scheduleID : localScheduleID});

        valNotFound = true;
        x = 0;

        while(x < this.reportStats[1].requestIDArr.length)
        {
            if (this.reportStats[1].requestIDArr[x].requestID === localRequestID)
            {
                valNotFound = false;
                break;
            }
            x++;
        };
        
        if(valNotFound)
            this.reportStats[1].requestIDArr.push({requestID : localRequestID});
    }
};


extractStats.fillFailedArrays = function(paramVOName, paramRunDate, paramStatus, paramErrorMessage, paramNumberOfRows, paramExtractDuration,
                    paramUploadDuration, paramTotalDuration, paramQueryDuration, paramFileName)
{

    var posRDTSVal = -1;
    var localPosVOName = -1;
    var runDateToSec = paramRunDate.toLocaleString().substr(0,19);

    for( var x=0; x < this.voFailedArrByVO.length; x++){
        if( this.voFailedArrByVO[x].voName === paramVOName)
        {
            localPosVOName = x;
            break;
        }
    }

    for( v=0; v < this.voFailedArrByDate.length; v++){
        if( this.voFailedArrByDate[v].voRunDate === runDateToSec)
        {
            posRDTSVal = v;
            break;
        }
    }

    if(posRDTSVal < 0)
    {
        this.voFailedArrByDate.push({voRunDate: runDateToSec});
        posRDTSVal = this.voFailedArrByDate.length - 1;
    }

    if (Array.isArray(this.voFailedArrByDate[posRDTSVal].detailsLine))
    {
        this.voFailedArrByDate[posRDTSVal].detailsLine.push({voName: paramVOName, errMsg: paramErrorMessage, runDate: paramRunDate, status: paramStatus, numberOfRows: paramNumberOfRows,
            extractDuration: paramExtractDuration, uploadDuration: paramUploadDuration, totalDuration: paramTotalDuration,
            queryDuration: paramQueryDuration, fileName: paramFileName});
    } 
    else
    {
        this.voFailedArrByDate[posRDTSVal].detailsLine = [{voName: paramVOName, errMsg: paramErrorMessage, runDate: paramRunDate, status: paramStatus, numberOfRows: paramNumberOfRows,
            extractDuration: paramExtractDuration, uploadDuration: paramUploadDuration, totalDuration: paramTotalDuration,
            queryDuration: paramQueryDuration, fileName: paramFileName}];
    }
    

    if(localPosVOName < 0)
    {
        this.voFailedArrByVO.push({voName: paramVOName});
        localPosVOName = this.voFailedArrByVO.length - 1;
    }

    if (Array.isArray(this.voFailedArrByVO[localPosVOName].detailsLine))
    {
                this.voFailedArrByVO[localPosVOName].detailsLine.push({runDate: paramRunDate, status: paramStatus, errMsg: paramErrorMessage,  numberOfRows : paramNumberOfRows,
                    extractDuration : paramExtractDuration, uploadDuration : paramUploadDuration, totalDuration : paramTotalDuration, 
                    queryDuration : paramQueryDuration, fileName : paramFileName});
    } 
    else
    {
        this.voFailedArrByVO[localPosVOName].detailsLine = [{runDate: paramRunDate, status: paramStatus, errMsg: paramErrorMessage,  numberOfRows : paramNumberOfRows,
                    extractDuration : paramExtractDuration, uploadDuration : paramUploadDuration, totalDuration : paramTotalDuration, 
                    queryDuration : paramQueryDuration, fileName : paramFileName}];
    }
};

extractStats.logData = function()
{
    console.log("VO Name Array");
    console.log("--------------------");
    this.voNameArr.forEach( function(rec) {
        console.log("VO Name = " + rec.voName);
        rec.detailsLine.forEach( function(detRec){
            console.log("    Detail: " +
            detRec.runDate + " | " +
            detRec.status + " | " +
            detRec.numberOfRows + " | " +
            detRec.extractDuration + " | " +
            detRec.uploadDuration + " | " +
            detRec.totalDuration + " | " +
            detRec.queryDuration + " | " + 
            detRec.fileName);
        });
    });

    console.log("Run Date Array");
    console.log("--------------------");
    this.voRunDateArr.forEach( function(rec) {
        console.log("Run Date to Second = " + rec.voRunDate);
        rec.detailsLine.forEach( function(detRec){
            console.log("    Detail: " +
            detRec.voName + " | " +
            detRec.runDate + " | " +
            detRec.status + " | " +
            detRec.numberOfRows + " | " +
            detRec.extractDuration + " | " +
            detRec.uploadDuration + " | " +
            detRec.totalDuration + " | " +
            detRec.queryDuration + " | " + 
            detRec.fileName);
        });
    });

    console.log("Failed Extracts By Date Array");
    console.log("--------------------");
    this.voFailedArrByDate.forEach( function(rec) {
        console.log("Run Date to Second = " + rec.voRunDate);
        rec.detailsLine.forEach( function(detRec){
            console.log("    Detail: " +
            detRec.voName + " | " +
            detRec.runDate + " | " +
            detRec.status + " | " +
            detRec.errMsg + " | " +
            detRec.numberOfRows + " | " +
            detRec.extractDuration + " | " +
            detRec.uploadDuration + " | " +
            detRec.totalDuration + " | " +
            detRec.queryDuration + " | " + 
            detRec.fileName);
        });
    });

    console.log("Failed Extracts By VO Name Array");
    console.log("--------------------");
    this.voFailedArrByVO.forEach( function(rec) {
        console.log("VO Name = " + rec.voName);
        rec.detailsLine.forEach( function(detRec){
            console.log("    Detail: " +
            detRec.runDate + " | " +
            detRec.status + " | " +
            detRec.errMsg + " | " +
            detRec.numberOfRows + " | " +
            detRec.extractDuration + " | " +
            detRec.uploadDuration + " | " +
            detRec.totalDuration + " | " +
            detRec.queryDuration + " | " + 
            detRec.fileName);
        });
    });


    console.log("Extracts By ScheduleID Array");
    console.log("--------------------");
    this.voJobIDArr.forEach( function(rec) {
        console.log("Schedule ID = " + rec.voSchedID);
        rec.reqIDList.forEach( function(reqRec) {
            console.log("  Requisition ID = " + reqRec.reqID);   
            reqRec.detailsLine.forEach( function(detRec){
                console.log("    Detail: " +
                detRec.voName + " | " +
                detRec.runDate + " | " +
                detRec.status + " | " +
                detRec.numberOfRows + " | " +
                detRec.extractDuration + " | " +
                detRec.uploadDuration + " | " +
                detRec.totalDuration + " | " +
                detRec.queryDuration + " | " + 
                detRec.fileName);
            });
        });
    });
   
    console.log("Report Statistics");
    console.log("--------------------");
    console.log( this.reportStats[0].oldestRunDate + ": " + this.reportStats[1].oldestRunDate);
    console.log( this.reportStats[0].recentRunDate + ": "+ ": " + this.reportStats[1].recentRunDate);
    console.log( this.reportStats[0].totalNumOfRowsInLogs + ": " + ": " + this.reportStats[1].totalNumOfRowsInLogs);

    console.log( "Count of Schedules processed:" + this.reportStats[1].scheduleIDArr.length);

    this.reportStats[1].scheduleIDArr.forEach( function(rec) {
        console.log( "   scheduleID  --> " + rec.scheduleID);
    });

    console.log( "Count of Requests processed:" + this.reportStats[1].requestIDArr.length);
    
    this.reportStats[1].requestIDArr.forEach(function(rec) {
        console.log( "   requestID  --> " + rec.requestID);
    });

    console.log( "Count of Files processed:"  + this.reportStats[1].fileListArr.length);

    this.reportStats[1].fileListArr.forEach(function(rec) {
        console.log( "    fileName  --> " + rec.fileName);
    });

    console.log( "Count of VO's processed:"  + this.reportStats[1].voListArr.length);

    this.reportStats[1].voListArr.forEach(function(rec) {
        console.log( "     voName --> " + rec.voName);
    });
    
    console.log("------  End of Logging ---------");
};

extractStats.renderVONameArr = function()
{
    var firstMainRow = new Boolean(true);
    var firstDetailRow = new Boolean(true);
    var voNameTable;
    
    this.voNameArr.forEach( function(rec) {
        if(firstMainRow)
        {
            voNameTable = "<H2>List Log Information by VO Name</H2><BR><table><thead><th>" + rec.voName.toString() + "</th>" +
                "<th>" + rec.detailsLine[0].runDate.toString() + "</th>" +
                "<th>" + rec.detailsLine[0].status.toString() + "</th>" +
                "<th>" + rec.detailsLine[0].numberOfRows.toString() + "</th>"+
                "<th>" + rec.detailsLine[0].extractDuration.toString() + "</th>" +
                "<th>" + rec.detailsLine[0].uploadDuration.toString() + "</th>" +
                "<th>" + rec.detailsLine[0].totalDuration.toString() + "</th>" +
                "<th>" + rec.detailsLine[0].queryDuration.toString() + "</th>" +
                "<th>" + rec.detailsLine[0].fileName.toString() + "</th></thead><tbody>";
            firstMainRow = false;
        }
        else
        {
            voNameTable = voNameTable + "<tr><td>" + rec.voName.toString() + "</td>";
            firstDetailRow = true;
            rec.detailsLine.forEach( function(detRec){

            if (firstDetailRow)
                firstDetailRow = false;
            else
                voNameTable = voNameTable + "<tr><td></td>";

            voNameTable = voNameTable + "<td>" + 
                    detRec.runDate.toString().replace("T", " ").replace("Z", "") + "</td>" +
                "<td>" + detRec.status.toString() + "</td>" +
                "<td>" + detRec.numberOfRows.toString() + "</td>" +
                "<td>" + detRec.extractDuration.toString() + "</td>" +
                "<td>" + detRec.uploadDuration.toString() + "</td>" +
                "<td>" + detRec.totalDuration.toString() + "</td>" +
                "<td>" + detRec.queryDuration.toString() + "</td>" +
                "<td>" + detRec.fileName.toString() + "</td></tr>";
            });
        }
    });
    voNameTable = voNameTable + "</tbody></table>";
    
    return(voNameTable);
};
    
extractStats.renderRunDateArr = function()
{
    var firstMainRow = new Boolean(true);
    var firstDetailRow = new Boolean(true);
    var voDateTable;

    this.voRunDateArr.forEach( function(rec) {
        if(firstMainRow)
        {
            voDateTable = "<H2>List Log Information by Date</H2><BR><table><thead><th>" + rec.voRunDate.toString() + "</th>";

            if (firstDetailRow)
            {
                voDateTable = voDateTable + "<th>" + rec.detailsLine[0].voName.toString() + "</th>" +
                    "<th>" + rec.detailsLine[0].runDate.toString() + "</th>"+
                    "<th>" + rec.detailsLine[0].status.toString() + "</th>" +
                    "<th>" + rec.detailsLine[0].numberOfRows.toString() + "</th>" +
                    "<th>" + rec.detailsLine[0].extractDuration.toString() + "</th>" +
                    "<th>" + rec.detailsLine[0].uploadDuration.toString() + "</th>" +
                    "<th>" + rec.detailsLine[0].totalDuration.toString() + "</th>" +
                    "<th>" + rec.detailsLine[0].queryDuration.toString() + "</th>" +
                    "<th>" + rec.detailsLine[0].fileName.toString() + "</th></thead><tbody>";
            }

            firstMainRow = false;
        }
        else
        {
            voDateTable = voDateTable + "<tr><td>" + rec.voRunDate.toString().replace("T", " ") + "</td>";
            firstDetailRow = true;
            rec.detailsLine.forEach( function(detRec){

                if (firstDetailRow)
                    firstDetailRow = false;
                else
                    voDateTable = voDateTable + "<tr><td></td>";

                voDateTable = voDateTable + "<td>" + detRec.voName.toString() + "</td>" +
                    "<td>" + detRec.runDate.toString().replace("T", " ").replace("Z", "") + "</td>"+
                    "<td>" + detRec.status.toString() + "</td>" +
                    "<td>" + detRec.numberOfRows.toString() + "</td>" +
                    "<td>" + detRec.extractDuration.toString() + "</td>" +
                    "<td>" + detRec.uploadDuration.toString() + "</td>" +
                    "<td>" + detRec.totalDuration.toString() + "</td>" +
                    "<td>" + detRec.queryDuration.toString() + "</td>" +
                    "<td>" + detRec.fileName.toString() + "</td></tr>";
            });
        }
    });
    
    voDateTable = voDateTable + "</tbody></table>";
    
    return(voDateTable);
};

extractStats.renderFailedArrByVO = function()
{
    var firstMainRow = new Boolean(true);
    var firstDetailRow = new Boolean(true);
    var voFailedTable;

    this.voFailedArrByVO.forEach( function(rec) {
        if(firstMainRow)
        {
            voFailedTable = "<H2>List Failed Extracts by VO</H2><BR><table><thead><th>" + rec.voName.toString() + "</th>";
            voFailedTable = voFailedTable + "<th>" + rec.detailsLine[0].runDate.toString() + "</th>"+
                "<th>" + rec.detailsLine[0].status.toString() + "</th>" +
                "<th>" + rec.detailsLine[0].errMsg.toString() + "</th>" +
                "<th>" + rec.detailsLine[0].numberOfRows.toString() + "</th>" +
                "<th>" + rec.detailsLine[0].extractDuration.toString() + "</th>" +
                "<th>" + rec.detailsLine[0].uploadDuration.toString() + "</th>" +
                "<th>" + rec.detailsLine[0].totalDuration.toString() + "</th>" +
                "<th>" + rec.detailsLine[0].queryDuration.toString() + "</th>" +
                "<th>" + rec.detailsLine[0].fileName.toString() + "</th></thead><tbody>";

            firstMainRow = false;
        }
        else
        {
            voFailedTable = voFailedTable + "<tr><td>" + rec.voName.toString() + "</td>";
            firstDetailRow = true;
            rec.detailsLine.forEach( function(detRec){
                if (firstDetailRow)
                    firstDetailRow = false;
                else
                    voFailedTable = voFailedTable + "<tr><td>";

                voFailedTable = voFailedTable + "<td>" + 
                        detRec.runDate.toString().replace("T", " ").replace("Z", "") + "</td>" +
                   "<td>" + detRec.status.toString() + "</td>" +
                    "<td>" + detRec.errMsg.toString() + "</td>" +
                    "<td>" + detRec.numberOfRows.toString() + "</td>" +
                    "<td>" + detRec.extractDuration.toString() + "</td>" +
                    "<td>" + detRec.uploadDuration.toString() + "</td>" +
                    "<td>" + detRec.totalDuration.toString() + "</td>" +
                    "<td>" + detRec.queryDuration.toString() + "</td>" +
                    "<td>" + detRec.fileName.toString() + "</td></tr>";
            });
        }
    });
    
    voFailedTable = voFailedTable + "</tbody></table>";
    
    return(voFailedTable);
};

extractStats.renderFailedArrByDate = function()
{
    var firstMainRow = new Boolean(true);
    var firstDetailRow = new Boolean(true);
    var voFailedTable;
    
    this.voFailedArrByDate.forEach( function(rec) {
        if(firstMainRow)
        {
            voFailedTable = "<H2>List Failed Extracts by Date</H2><BR><table><thead><th>" + 
               rec.voRunDate.toString().replace("T", " ").replace("Z", "") + "</th>";

                voFailedTable = voFailedTable + "<th>" + rec.detailsLine[0].voName.toString() + "</th>"+
                    "<th>" + rec.detailsLine[0].errMsg.toString() + "</th>" +
                    "<th>" + rec.detailsLine[0].status.toString() + "</th>" +
                    "<th>" + rec.detailsLine[0].numberOfRows.toString() + "</th>" +
                    "<th>" + rec.detailsLine[0].extractDuration.toString() + "</th>" +
                    "<th>" + rec.detailsLine[0].uploadDuration.toString() + "</th>" +
                    "<th>" + rec.detailsLine[0].totalDuration.toString() + "</th>" +
                    "<th>" + rec.detailsLine[0].queryDuration.toString() + "</th>" +
                    "<th>" + rec.detailsLine[0].fileName.toString() + "</th></thead><tbody>";
            firstMainRow = false;
        }
        else
        {
            voFailedTable = voFailedTable + "<tr><td>" + 
                    rec.voRunDate.toString().replace("T", " ").replace("Z", "") + "</td>";
            firstDetailRow = true;
            rec.detailsLine.forEach( function(detRec){
                if (firstDetailRow)
                {
                    voFailedTable = voFailedTable + "<td>" + detRec.voName + "</td>";
                    firstDetailRow = false;
                }
                else
                    voFailedTable = voFailedTable + "<tr><td></td><td>";

                voFailedTable = voFailedTable + "<td>" + detRec.errMsg.toString() + "</td>" +
                        "<td>" + detRec.status.toString() + "</td>" +
                        "<td>" + detRec.numberOfRows.toString() + "</td>" +
                        "<td>" + detRec.extractDuration.toString() + "</td>" +
                        "<td>" + detRec.uploadDuration.toString() + "</td>" +
                        "<td>" + detRec.totalDuration.toString() + "</td>" +
                        "<td>" + detRec.queryDuration.toString() + "</td>" +
                        "<td>" + detRec.fileName.toString() + "</td></tr>";
            });
        };
    });
    
    voFailedTable = voFailedTable + "</tbody></table>";
    
    return(voFailedTable);
};

extractStats.renderReportStats = function()
{
    var date = new Date();
    var reportStatsTable = "<H2>Extract Statistics Summary</H2><BR><table><thead>" +
        "<th>Report Processing Date/Time</th>" +
        "<th>" + this.reportStats[0].oldestRunDate + "</th>"+
        "<th>" + this.reportStats[0].recentRunDate + "</th>"+
        "<th>" + this.reportStats[0].totalNumOfRowsInLogs.toString() + "</th>" +
        "<th>" + this.reportStats[0].scheduleIDArr[0].scheduleID + "</th>" +
        "<th>" + this.reportStats[0].requestIDArr[0].requestID + "</th>" +
        "<th>" + this.reportStats[0].fileListArr[0].fileName + "</th>" +
        "<th>" + this.reportStats[0].voListArr[0].voName + "</th></th></thead><tbody><tr>" +
        "<td>" + date.getFullYear() + '-' + (date.getMonth() + 1).toString().padStart(2, '0') + '-' +
                date.getDate().toString().padStart(2, '0') + ' / ' +
                date.getHours().toString().padStart(2, '0') + ':' +
                date.getMinutes().toString().padStart(2, '0') + ':' +
                date.getSeconds().toString().padStart(2, '0') + "</td>" +
        "<td>" + this.reportStats[1].oldestRunDate.toString().replace("T", " ").replace("Z", "") + "</td>"+
        "<td>" + this.reportStats[1].recentRunDate.toString().replace("T", " ").replace("Z", "") + "</td>"+
        "<td>" + this.reportStats[1].totalNumOfRowsInLogs.toString() + "</td>" +
        "<td>" + this.reportStats[1].scheduleIDArr.length.toString() + "</td>" +
        "<td>" + this.reportStats[1].requestIDArr.length.toString() + "</td>" +
        "<td>" + this.reportStats[1].fileListArr.length.toString() + "</td>" +
        "<td>" + this.reportStats[1].voListArr.length.toString() + "</td></tr></tbody></table>";

    return(reportStatsTable);
    
};

extractStats.renderBatchJobArr= function()
{
    var firstMainRow = new Boolean(true);
    var firstDetailRow = new Boolean(true);
    var firstReqRow = new Boolean(true);

    var voSchedIDTable;
    
    this.voJobIDArr.forEach( function(rec) {
        if(firstMainRow)
        {
            voSchedIDTable = "<H2>List by Schedule ID and Request ID</H2><BR><table><thead><th>" + 
                    rec.voSchedID + "</th><th>" + rec.reqIDList[0].reqID + "</th>" +
                    "<th>" + rec.reqIDList[0].detailsLine[0].voName.toString() + "</th>"+
                    "<th>" + rec.reqIDList[0].detailsLine[0].runDate.toString() + "</th>"+
                    "<th>" + rec.reqIDList[0].detailsLine[0].status.toString() + "</th>" +
                    "<th>" + rec.reqIDList[0].detailsLine[0].numberOfRows.toString() + "</th>" +
                    "<th>" + rec.reqIDList[0].detailsLine[0].extractDuration.toString() + "</th>" +
                    "<th>" + rec.reqIDList[0].detailsLine[0].uploadDuration.toString() + "</th>" +
                    "<th>" + rec.reqIDList[0].detailsLine[0].totalDuration.toString() + "</th>" +
                    "<th>" + rec.reqIDList[0].detailsLine[0].queryDuration.toString() + "</th>" +
                    "<th>" + rec.reqIDList[0].detailsLine[0].fileName.toString() + "</th></thead><tbody>";
            firstMainRow = false;
        }
        else
        {
            voSchedIDTable = voSchedIDTable + "<tr><td>" + 
                    rec.voSchedID + "</td>";
            
            firstReqRow = true;
            
            rec.reqIDList.forEach( function(reqidRec){
                if(! firstReqRow)
                {
                    voSchedIDTable = voSchedIDTable + "<tr><td></td>";
                }
                else
                {
                    firstReqRow = false;
                }
                
                voSchedIDTable = voSchedIDTable + "<td>" + reqidRec.reqID + "</td>";
                firstDetailRow = true;
               
                reqidRec.detailsLine.forEach( function(detRec){
                    if(firstDetailRow)
                    {
                        firstDetailRow = false;
                    }
                    else
                    {
                        voSchedIDTable = voSchedIDTable + "<td></td><td></td>";
                    }
                    
                    voSchedIDTable = voSchedIDTable + 
                            "<td>" + detRec.voName + "</td>" +
                            "<td>" + detRec.runDate.toString().replace("T", " ").replace("Z", "") + "</td>" +
                            "<td>" + detRec.status.toString() + "</td>" +
                            "<td>" + detRec.numberOfRows.toString() + "</td>" +
                            "<td>" + detRec.extractDuration.toString() + "</td>" +
                            "<td>" + detRec.uploadDuration.toString() + "</td>" +
                            "<td>" + detRec.totalDuration.toString() + "</td>" +
                            "<td>" + detRec.queryDuration.toString() + "</td>" +
                            "<td>" + detRec.fileName.toString() + "</td></tr>";
                    });
            });
        }
    });
    
    voSchedIDTable = voSchedIDTable + "</tbody></table>";
    
    return(voSchedIDTable);
};

extractStats.visualizeStatsData  = function(appPort)
{
    var voDateTable = this.renderRunDateArr();
    var voNameTable = this.renderVONameArr();
    var voFailedByVOTable = this.renderFailedArrByVO();
    var voFailedByDateTable = this.renderFailedArrByDate();
    var reportStatsTable = this.renderReportStats();
    var voScheduleTable = this.renderBatchJobArr();
    
    app.get('/reportStats', (req, res) => res.send( this.htmlHeader + reportStatsTable + "</body></html>"));
    app.get('/byDate', (req, res) => res.send( this.htmlHeader + voDateTable + "</body></html>"));
    app.get('/byName', (req, res) => res.send(  this.htmlHeader + voNameTable + "</body></html>"));
    app.get('/bySchedID', (req, res) => res.send(  this.htmlHeader + voScheduleTable + "</body></html>"));
    app.get('/byFailStatusVO', (req, res) => res.send( this.htmlHeader + voFailedByVOTable + "</body></html>"));
    app.get('/byFailStatusDate', (req, res) => res.send( this.htmlHeader + voFailedByDateTable + "</body></html>"));
    app.get('/', (req, res) => res.send( "<html>" + this.rootHtmlHeader + "<body>" +
	"<div class=\"submit\">" +
	"<table>" +
	"		<tr>" +
        "			<td>" +
        "				<form>" +
	"					<button type=\"button\" class=\"submit\" onclick=\"showStats('http://localhost:" + appPort + "/reportStats')\">Statistics Summary</button>" +
	"				</form>" +
	"			</td>" +
	"			<td>" +
	"				<form>" +
	"					<button type=\"button\" class=\"submit\" onClick=\"javascript:showStats('http://localhost:" + appPort + "/byDate')\">Extracts by Run Date</button>" +
	"				</form>" +
	"			</td>" +
	"			<td>" +
        "				<form>" +
	"					<button type=\"button\" class=\"submit\" onclick=\"showStats('http://localhost:" + appPort + "/byName')\">Extracts by VO</button>" +
	"				</form>" +
	"			</td>" +
        	"			<td>" +
        "				<form>" +
	"					<button type=\"button\" class=\"submit\" onclick=\"showStats('http://localhost:" + appPort + "/bySchedID')\">Extracts by Schedule</button>" +
	"				</form>" +
	"			</td>" +
	"			<td>" +
	"				<form>" +
	"					<button type=\"button\" class=\"submit\" onClick=\"javascript:showStats('http://localhost:" + appPort + "/byFailStatusVO')\">Failed by VO</button>" +
	"				</form>" +
	"			</td>" +
	"			<td>" +
	"				<form>" +
	"					<button type=\"button\" class=\"submit\" onClick=\"javascript:showStats('http://localhost:" + appPort + "/byFailStatusDate')\">Failed by Date</button>" +
	"				</form>" +
	"			</td>" +

	"		</tr>" +
	"	</table>" +
	"</div>" +
	"	<hr>" +
	"	<iframe id=\"if1\" style=\"border: 0; width:100%;\" src=\"http://localhost:" + appPort + "/reportStats\">" +
	"	</iframe>" +
	"</body></html>"));

    console.log("Started Web Server at port " + appPort);
    app.listen(appPort);
};

function main(myArgs)
{
    var debugFlag = new Boolean;
    var appPort = 3000;
    var arrNum = 0;
    var jsonInput = new Array();
    
    debugFlag = false;
   
    if (myArgs.length < 3)
    {
        console.log("Error: insufficient number of arguments!");
        console.log( "Usage: " + myArgs[0] + " " + myArgs[1] + " <File Path with EXTRACT JSON Log Files> [port=value between 1024 and 65554] [log=y|Y]");
        console.log( "          port=value  -> web port - default value = 3000 [optional]");
        console.log( "          log=y|Y     ->  console log y|Y - default value = no [optional]");
        process.exit();
    }
        
    var filePath = myArgs[2];
    
    for(x = 3; x < myArgs.length; x++){
        var equalPos = myArgs[x].toString().indexOf("=", 0);
        var paramName, paramVal;
        if(equalPos > 0)
        {
            paramName = myArgs[x].toString().substring(0, equalPos);
            paramVal = myArgs[x].toString().substring(equalPos + 1, myArgs[x].toString().length);

            if (paramName === "port")
            {
                if (paramVal.match(/^[0-9]+$/) !== null )
                {
                    if( (paramVal < 1000) || (paramVal > 65554) )
                        console.log("Hint: parameter <port> has an invalid value=" + paramVal + " - using default value 3000 instead!");
                    else
                        appPort = paramVal;

                };
            }

            if(paramName === "log")
            {
                if(paramVal.toString().toUpperCase() === 'Y')
                    debugFlag = true;
                else
                    debugFlag = false;
            }
        }
    }

    fs.readdir(filePath, function (err, files) {
        if (err) {
            return console.log('Unable to scan directory: ' + err);
        } 

        files.forEach(function (file) {
            jsonInput.length =  arrNum + 1;
            fullFileName = filePath.toString() + "/" + file.toString();
            jsonInput[arrNum] = JSON.parse(fs.readFileSync(fullFileName, 'utf8'));
            var recVal = jsonInput[arrNum];
            extractStats.handleData(recVal, arrNum, file.toString());
            arrNum++;
        });

        extractStats.createArrays();
        
        if(debugFlag)
            extractStats.logData();

        extractStats.visualizeStatsData(appPort);
    });
}

main(process.argv);
